/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.column;

import java.text.DecimalFormat;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;

public class Editor_DECIMAL
extends AbstractEditor {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private final int minFraction;
    private final DecimalFormat format;
    private final String defValue;

    public Editor_DECIMAL() {
        this.minFraction = 0;
        this.format = null;
        this.defValue = null;
    }

    private Editor_DECIMAL(DBColumn dBColumn) {
        super(dBColumn);
        this.minFraction = dBColumn.getSizeY();
        String string = dBColumn.getRendererParam();
        if (string == null || string.length() == 0 || string.equals("_")) {
            string = "#,##0.#";
        }
        this.format = new DecimalFormat(string);
        String string2 = dBColumn.getDefault();
        double d = 0.0;
        if (string2 != null && string2.length() != 0 && !string2.equals("_")) {
            d = StringUtil.parseDouble((String)string2);
        }
        this.defValue = this.format.format(d);
        int n = (int)((double)dBColumn.getSizeX() * 4.0 / 3.0) + this.minFraction + 2;
        this.attributes.set("maxlength", String.valueOf(n));
        this.tagBuffer.add(XHTMLTag.inputAttri((Attributes)this.attributes));
    }

    public CellEditor newInstance(DBColumn dBColumn) {
        return new Editor_DECIMAL(dBColumn);
    }

    public String getValue(String string) {
        return super.getValue(this.formatValue(string));
    }

    public String getValue(int n, String string) {
        return super.getValue(n, this.formatValue(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String formatValue(String string) {
        String string2;
        if (string == null || string.trim().length() == 0) {
            return this.defValue;
        }
        double d = StringUtil.parseDouble((String)string);
        DecimalFormat decimalFormat = this.format;
        synchronized (decimalFormat) {
            string2 = this.format.format(d);
        }
        return string2;
    }
}

