/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBColumnConfig;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.resource.CodeData;
import org.opengion.hayabusa.resource.LabelData;
import org.opengion.hayabusa.taglib.HTMLTagSupport;

public class ColumnEditorTag
extends HTMLTagSupport {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final long serialVersionUID = 4000L;
    private transient LabelData labelData = null;
    private String tableId = "h_tblmdl";
    private String[] columns = null;
    private boolean allColumns = false;
    private String className = null;
    private String size = null;
    private String maxlength = null;
    private String writable = null;
    private String renderer = null;
    private String editor = null;
    private String dbType = null;
    private String codeName = null;
    private String codeList = null;
    private String codeGroup = null;
    private String defaultVal = null;
    private String parameter = null;
    private String dbid = null;
    private String addNoValue = null;
    private static final String DEFAULT_ADD_NO_VALUE = "true";
    private String eventColumn = null;
    private String rawParameter = null;
    private String eventURL = null;
    private String mustType = null;
    private boolean useLabelMap = false;
    private Map<String, LabelData> labelMap = null;

    @Override
    public int doStartTag() {
        if ("DBMENU".equalsIgnoreCase(this.editor)) {
            this.className = "VARCHAR2";
            this.renderer = "DBMENU";
            this.editor = "DBMENU";
            if (this.addNoValue == null) {
                this.addNoValue = DEFAULT_ADD_NO_VALUE;
            }
        }
        return 2;
    }

    @Override
    public int doAfterBody() {
        String string = this.getBodyString();
        if (string != null && string.length() > 0) {
            if (this.useLabelMap) {
                this.labelMap = this.getResource().getLabelMap(string.trim());
            } else {
                if (this.eventColumn != null && this.eventColumn.length() > 0) {
                    this.rawParameter = this.getBodyRawString().trim();
                }
                this.parameter = string.trim();
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() {
        block6: {
            this.debugPrint();
            DBTableModel dBTableModel = (DBTableModel)this.getObject(this.tableId);
            if (dBTableModel == null) {
                return 6;
            }
            if (this.columns == null) break block6;
            if (this.allColumns) {
                int n = dBTableModel.getColumnCount();
                block0: for (int i = 0; i < n; ++i) {
                    DBColumn dBColumn = dBTableModel.getDBColumn(i);
                    for (int j = 0; j < this.columns.length; ++j) {
                        String string = this.columns[j].replace("*", "");
                        if (dBColumn.getName().indexOf(string) != 0) continue;
                        DBColumnConfig dBColumnConfig = this.getModifyConfig(dBColumn);
                        dBTableModel.setDBColumn(i, new DBColumn(dBColumnConfig));
                        if (this.mustType == null) continue block0;
                        dBTableModel.addMustType(i, this.mustType);
                        continue block0;
                    }
                }
            } else {
                for (int i = 0; i < this.columns.length; ++i) {
                    int n = dBTableModel.getColumnNo(this.columns[i]);
                    DBColumn dBColumn = dBTableModel.getDBColumn(n);
                    DBColumnConfig dBColumnConfig = this.getModifyConfig(dBColumn);
                    dBTableModel.setDBColumn(n, new DBColumn(dBColumnConfig));
                    if (this.mustType == null) continue;
                    dBTableModel.addMustType(n, this.mustType);
                }
            }
        }
        return 6;
    }

    @Override
    protected String makeTag() {
        return null;
    }

    @Override
    protected void release2() {
        super.release2();
        this.tableId = "h_tblmdl";
        this.columns = null;
        this.allColumns = false;
        this.labelData = null;
        this.className = null;
        this.size = null;
        this.maxlength = null;
        this.writable = null;
        this.renderer = null;
        this.editor = null;
        this.dbType = null;
        this.codeName = null;
        this.codeList = null;
        this.codeGroup = null;
        this.defaultVal = null;
        this.parameter = null;
        this.dbid = null;
        this.addNoValue = null;
        this.mustType = null;
        this.useLabelMap = false;
        this.labelMap = null;
        this.eventColumn = null;
        this.rawParameter = null;
        this.eventURL = null;
    }

    private DBColumnConfig getModifyConfig(DBColumn dBColumn) {
        LabelData labelData;
        CodeData codeData;
        String string;
        DBColumnConfig dBColumnConfig = dBColumn.getConfig();
        String string2 = this.get("lang");
        if (string2 != null) {
            dBColumnConfig.setLang(string2);
        }
        if (this.labelData != null) {
            dBColumnConfig.setLabelData(this.labelData);
        }
        if (this.className != null) {
            dBColumnConfig.setClassName(this.className);
        }
        if (this.size != null) {
            dBColumnConfig.setViewLength(this.size);
        }
        if (this.maxlength != null) {
            dBColumnConfig.setMaxlength(this.maxlength);
        }
        if (this.writable != null) {
            dBColumnConfig.setWritable(this.writable);
        }
        if (this.renderer != null) {
            dBColumnConfig.setRenderer(this.renderer);
        }
        if (this.editor != null) {
            dBColumnConfig.setEditor(this.editor);
        }
        if (this.dbType != null) {
            dBColumnConfig.setDbType(this.dbType);
        }
        if (this.defaultVal != null) {
            dBColumnConfig.setDefault(this.defaultVal);
        }
        if (this.parameter != null) {
            dBColumnConfig.setParameter(this.parameter);
        }
        if (this.dbid != null) {
            dBColumnConfig.setDbid(this.dbid);
        }
        if (this.eventColumn != null) {
            dBColumnConfig.setEventColumn(this.eventColumn);
        }
        if (this.eventURL != null) {
            dBColumnConfig.setEventURL(this.eventURL);
        }
        if (this.rawParameter != null) {
            dBColumnConfig.setRawParameter(this.rawParameter);
        }
        if ((string = this.get("roles")) != null) {
            dBColumnConfig.setRoles(string);
        }
        if (this.codeName != null) {
            codeData = this.getResource().getCodeData(this.codeName);
            dBColumnConfig.setCodeData(codeData);
        }
        if (this.codeList != null && (codeData = dBColumnConfig.getCodeData()) != null) {
            dBColumnConfig.setCodeData(codeData.subsetList(this.codeList));
        }
        if (this.codeGroup != null && (codeData = dBColumnConfig.getCodeData()) != null && codeData.useGroup()) {
            dBColumnConfig.setCodeData(codeData.subsetGroup(this.codeGroup));
        }
        if (this.addNoValue != null) {
            boolean bl = Boolean.valueOf(this.addNoValue);
            dBColumnConfig.setAddNoValue(bl);
        }
        dBColumnConfig.setEditorAttributes(this.getAttributes());
        if (this.useLabelMap && this.labelMap != null && (labelData = this.labelMap.get(dBColumn.getName())) != null) {
            dBColumnConfig.setLabelData(labelData);
        }
        return dBColumnConfig;
    }

    public void setColumn(String string) {
        if (this.columns != null) {
            String string2 = "columns \u3068\u306e\u540c\u6642\u30bb\u30c3\u30c8\u306f\u51fa\u6765\u307e\u305b\u3093\u3002: " + HybsSystem.CR + "column=[" + string + "] , " + "columns=[" + StringUtil.array2csv((String[])this.columns) + "]";
            throw new HybsSystemException(string2);
        }
        String string3 = this.getRequestParameter(string);
        if (string3 != null && string3.length() > 0) {
            this.columns = new String[]{string3};
            this.allColumns = string3.indexOf(42) >= 0;
        }
    }

    public void setColumns(String string) {
        if (this.columns != null) {
            String string2 = "column \u3068\u306e\u540c\u6642\u30bb\u30c3\u30c8\u306f\u51fa\u6765\u307e\u305b\u3093\u3002: " + HybsSystem.CR + "column=[" + StringUtil.array2csv((String[])this.columns) + "] , " + "columns=[" + string + "]";
            throw new HybsSystemException(string2);
        }
        String string3 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string3 != null) {
            this.allColumns = string3.indexOf(42) >= 0;
            this.columns = StringUtil.csv2Array((String)string3);
            if (this.columns.length == 0) {
                this.columns = null;
            }
        }
    }

    public void setLabel(String string) {
        this.labelData = this.getResource().getLabelData(this.getRequestParameter(string));
    }

    public void setClassName(String string) {
        this.className = StringUtil.nval((String)this.getRequestParameter(string), (String)this.className);
    }

    public void setMaxlength(String string) {
        this.maxlength = StringUtil.nval((String)this.getRequestParameter(string), (String)this.maxlength);
    }

    public void setSize(String string) {
        this.size = StringUtil.nval((String)this.getRequestParameter(string), (String)this.size);
    }

    public void setWritable(String string) {
        this.writable = StringUtil.nval((String)this.getRequestParameter(string), (String)this.writable);
    }

    public void setRenderer(String string) {
        this.renderer = StringUtil.nval((String)this.getRequestParameter(string), (String)this.renderer);
    }

    public void setEditor(String string) {
        this.editor = StringUtil.nval((String)this.getRequestParameter(string), (String)this.editor);
    }

    public void setDbType(String string) {
        this.dbType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbType);
    }

    public void setCodeName(String string) {
        this.codeName = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeName);
    }

    public void setCodeList(String string) {
        this.codeList = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeList);
    }

    public void setCodeGroup(String string) {
        this.codeGroup = StringUtil.nval((String)this.getRequestParameter(string), (String)this.codeGroup);
    }

    public void setParameter(String string) {
        this.parameter = StringUtil.nval((String)this.getRequestParameter(string), (String)this.parameter);
        this.rawParameter = StringUtil.nval((String)string, (String)this.parameter);
    }

    public void setDefaultVal(String string) {
        this.defaultVal = StringUtil.nval((String)this.getRequestParameter(string), (String)this.defaultVal);
    }

    public void setMust(String string) {
        boolean bl = StringUtil.nval((String)this.getRequestParameter(string), (boolean)false);
        if (bl) {
            this.mustType = "must";
            this.add("class", "must");
        }
    }

    public void setMustAny(String string) {
        if (this.mustType == null) {
            this.mustType = StringUtil.nval((String)this.getRequestParameter(string), null);
            if (DEFAULT_ADD_NO_VALUE.equalsIgnoreCase(this.mustType)) {
                this.mustType = "mustAny";
            }
            this.add("class", this.mustType);
        }
    }

    public void setAddNoValue(String string) {
        this.addNoValue = StringUtil.nval((String)this.getRequestParameter(string), (String)this.addNoValue);
    }

    public void setUseLabelMap(String string) {
        this.useLabelMap = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLabelMap);
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
    }

    public void setDbid(String string) {
        this.dbid = StringUtil.nval((String)this.getRequestParameter(string), (String)this.dbid);
    }

    public void setEventColumn(String string) {
        this.eventColumn = StringUtil.nval((String)this.getRequestParameter(string), (String)this.eventColumn);
    }

    public void setEventURL(String string) {
        this.eventURL = StringUtil.nval((String)this.getRequestParameter(string), (String)this.eventURL);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("tableId", (Object)this.tableId).println("columns", (Object[])this.columns).println("allColumns", (Object)this.allColumns).println("className", (Object)this.className).println("size", (Object)this.size).println("maxlength", (Object)this.maxlength).println("writable", (Object)this.writable).println("renderer", (Object)this.renderer).println("editor", (Object)this.editor).println("codeName", (Object)this.codeName).println("dbType", (Object)this.dbType).println("defaultVal", (Object)this.defaultVal).println("parameter", (Object)this.parameter).println("dbid", (Object)this.dbid).println("addNoValue", (Object)this.addNoValue).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

