/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

import org.opengion.hayabusa.db.DBTableModel;

/**
 * <p>TableFilter_REPORTLAYOUT は、TableFilter インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。<br />
 *
 * ここでは、GE52(帳票レイアウトテーブル)の変更時に、
 *  GE52のSEQ,開始位置
 *  (GE54のSQLの再定義) 廃止
 * を行うための情報を生成しています。
 *
 * @og.rev 4.3.7.0 (2009/06/01) 新規作成
 *
 * @version  0.9.0  2000/10/17
 * @author   Hiroki Nakamura
 * @since    JDK1.1,
 */
public class TableFilter_REPORTLAYOUT extends AbstractTableFilter {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "5.1.1.0 (2009/12/01)" ;

//	private static final String CR = System.getProperty("line.separator");	// 5.1.1.0 (2009/12/01) CR 定義をAbstractTableFilterで行う。

//	private static final String LAST_SQL_1 =
//		" FROM GE51 WHERE FGJ = '1'" + CR
//		+ " AND SYSTEM_ID = ? " + CR
//		+ " AND YKNO = ? " + CR
//		+ " AND KBTEXT = '";
//
//	private static final String LAST_SQL_2 =
//		"'" + CR + "ORDER BY EDNO";

	/**
	 * DBTableModel処理を実行します。<br />
	 * 
	 * @og.rev 4.3.7.0 (2009/06/01) 新規追加
	 * @og.rev 5.1.0.0 (2009/11/04) TEXT ⇒ TEXT_DATA , COLUMN_NAME ⇒ CLM
	 * @og.rev 5.1.2.0 (2010/01/01) データ分割のためのSQL文の生成を廃止します。(帳票クラス内で直接分割)
	 *
	 * @return DBTableModel
	 */
	public DBTableModel execute() {
		int systemIdNo	= table.getColumnNo( "SYSTEM_ID" );
		int listIdNo	= table.getColumnNo( "LISTID" );
		int kbtextNo	= table.getColumnNo( "KBTEXT" );
		int clmNo		= table.getColumnNo( "CLM" );		// 5.1.0.0 (2009/11/04) COLUMN_NAME ⇒ CLM
		int seqNo		= table.getColumnNo( "SEQ" );
		int lengthNo	= table.getColumnNo( "USE_LENGTH" );
		int strposNo	= table.getColumnNo( "START_POS" );
//		int sqlTypeNo	= table.getColumnNo( "SQL_TYPE" );
//		int sqlBodyNo	= table.getColumnNo( "SQL_BODY" );
//		String substrb	= getValue( "SUBSTRB" );

		if( systemIdNo < 0 || listIdNo < 0 || kbtextNo < 0 || clmNo < 0
				|| seqNo < 0 || lengthNo < 0 || strposNo < 0 ) {
//				|| sqlTypeNo < 0 || sqlBodyNo < 0
//				|| substrb == null || substrb.length() == 0 )
			return table;
		}

		int seq = 0;
		int strpos = 1;
		String[] data = null;
//		String[] pre = null;
		
		String resetKey = null;
		String preKey = null;
//		StringBuilder sql = new StringBuilder();
//		sql.append( "SELECT" ).append( CR ).append( " " );
		for( int row = 0; row < rowNo.length; row ++ ) {
			data = table.getValues( rowNo[row] );
			resetKey = data[systemIdNo] + "__" + data[listIdNo] + "__" + data[kbtextNo];
			                
//			if( pre != null && !(preKey.equals( resetKey ) ) ) {
			if( preKey != null && !(preKey.equals( resetKey ) ) ) {
				seq = 0;
				strpos = 1;
//				pre[sqlTypeNo] = pre[kbtextNo];
//				pre[sqlBodyNo] = sql.append( LAST_SQL_1 ).append( pre[sqlTypeNo] ).append(  LAST_SQL_2 ).toString();

//				sql = new StringBuilder();
//				sql.append( "SELECT" ).append( CR ).append( " " );
			}

//			if( seq > 0 ) {
//				sql.append( "," );
//			}

			seq += 10;
			data[seqNo] = String.valueOf( seq );
			data[strposNo] = String.valueOf( strpos );

//			// 5.1.0.0 (2009/11/04) TEXT ⇒ TEXT_DATA
//			sql.append( "RTRIM(" ).append( substrb ).append( "(TEXT_DATA," ).append( data[strposNo] )
//			.append( "," ).append( data[lengthNo] ).append( ")) " ).append(  data[clmNo] ).append( CR );

			strpos += Integer.valueOf( data[lengthNo] );

			preKey = resetKey;
//			pre = data;
		}

//		data[sqlTypeNo] = data[kbtextNo];
//		data[sqlBodyNo] = sql.append( LAST_SQL_1 ).append( data[kbtextNo] ).append(  LAST_SQL_2 ).toString();

		return table;
	}
}
