/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.fukurou.db.DBUtil;

import static org.opengion.fukurou.util.StringUtil.nval ;

import java.util.Locale ;

/**
 * 【廃止】画面上にデータベースの検索結果を表示するタグです（代わりにvalueタグを使用してください）。
 *
 * 例えば、社員番号のキーに対して、社員名称を表示させたい場合に使用します。
 * command = "NEW" の場合と、SQL文が完全に成立した場合に、SQL文が実行されます。
 * SQL文の{&#064;XXXX} に、値が設定されていない場合は,SQL文が完全に成立したとは
 * みなされませんので、データベースへのアクセスは実行されません。
 *
 * SQL文が実行されなかった場合は、defaultVal にセットされた値を代わりに
 * 表示します。初期値は、スペースです。
 *
 * 検索時のカラムが複数ある場合は,スペースで連結して返します。
 * 行が複数ある場合は,各行（複数カラム）を連結した後に、全行を連結します。
 *
 * @og.group 画面部品
 *
 * @version  4.0
 * @author   Kazuhiko Hasegawa
 * @since    JDK5.0,
 * @deprecated
 */
@Deprecated public class SQLTag extends CommonTagSupport {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/01/31)" ;

	private static final long serialVersionUID = 4000 ;	// 4.0.0 (2005/01/31)

	/** command 引数に渡す事の出来る コマンド  新規 {@value} */
	public static final String CMD_NEW	 = "NEW" ;
	/** command 引数に渡す事の出来る コマンド リスト  */
	private static final String COMMAND_LIST = CMD_NEW ;

	private String[][]	vals	= null;
	private String		defaultVal	= " ";
	private String		command		= null;

	/**
	 * Taglibの開始タグが見つかったときに処理する doStartTag() を オーバーライドします。
	 *
	 * @return  int
	 */
	@Override
	public int doStartTag() {
		if( ! check( command, COMMAND_LIST ) ) { return(SKIP_BODY); }
		return( EVAL_BODY_BUFFERED );	// Body を評価する。（ extends BodyTagSupport 時）
	}

	/**
	 * Taglibのタグ本体を処理する doAfterBody() を オーバーライドします。
	 *
	 * @og.rev 3.1.1.0 (2003/03/28) ボディの内容を取得する処理を、CommonTagSupport で行う。
	 * @og.rev 3.8.7.0 (2006/12/15) アクセスログ取得の為,ApplicationInfo オブジェクトを設定
	 *
	 * @return	int
	 */
	@Override
	public int doAfterBody() {
		String sql = getBodyString();

		if( ! isNull() ) {
			vals  = DBUtil.dbExecute( sql,null,getApplicationInfo() );
		}

		return(SKIP_BODY);
	}

	/**
	 * Taglibの終了タグが見つかったときに処理する doEndTag() を オーバーライドします。
	 *
	 * @og.rev 3.1.1.2 (2003/04/04) Tomcat4.1 対応。release2() を doEndTag()で呼ぶ。
	 *
	 * @return  int
	 */
	@Override
	public int doEndTag() {
		debugPrint();		// 4.0.0 (2005/02/28)
		jspPrint( makeLabel() );

		return(EVAL_PAGE);
	}

	/**
	 * タグリブオブジェクトをリリースします。
	 * キャッシュされて再利用されるので、フィールドの初期設定を行います。
	 *
	 * @og.rev 2.0.0.4 (2002/09/27) カスタムタグの release() メソッドを、追加
	 * @og.rev 3.1.1.2 (2003/04/04) Tomcat4.1 対応。release2() を doEndTag()で呼ぶ。
	 *
	 */
	@Override
	protected void release2() {
		super.release2();
		vals		= null;
		defaultVal	= " ";
		command		= null;
	}

	/**
	 * 【廃止】検索結果の値が null の場合の初期値をセットします。
	 *
	 * @og.tag 検索結果の値が null の場合の初期値をセットします。
	 *
	 * @param   val 初期値
	 * @deprecated
	 */
	@Deprecated public void setDefaultVal( final String val ) {
		defaultVal = nval( getRequestParameter( val ),defaultVal );
	}

	/**
	 * 検索結果を作成します。
	 *
	 * 検索結果のカラムが複数存在する場合は、スペースで区切りながら文字列を連結させて
	 * 結果を作成します。
	 * さらに、複数の行が存在する場合は、それらもスペースで区切りながら連結させます。
	 *
	 */
	private String makeLabel() {
		if( vals == null ) { return defaultVal; }

		StringBuilder buf = new StringBuilder( HybsSystem.BUFFER_MIDDLE );
		for( int row=0; row<vals.length; row++ ) {
			if( vals[row] != null ) {
				for( int clm=0; clm<vals[row].length; clm++ ) {
					buf.append( vals[row][clm] );
					buf.append( " " );
				}
			}
		}

		return buf.toString();
	}

	/**
	 * 【廃止】コマンド(NEW)をセットします。
	 *
	 * @og.tag
	 * コマンドは,HTMLから（get/post)指定されますので,CMD_xxx で設定される
	 * フィールド定数値のいづれかを、指定できます。
	 *
	 * @param	cmd コマンド（public static final 宣言されている文字列)
	 * @see		<a href="{@docRoot}/constant-values.html#org.opengion.hayabusa.taglib.SQLTag.CMD_NEW">コマンド定数</a>
	 * @deprecated
	 */
	@Deprecated public void setCommand( final String cmd ) {
		String cmd2 = getRequestParameter( cmd );
		if( cmd2 != null && cmd2.length() > 0 ) { command = cmd2.toUpperCase(Locale.JAPAN); }
	}

	/**
	 * このオブジェクトの文字列表現を返します。
	 * 基本的にデバッグ目的に使用します。
	 *
	 * @return このクラスの文字列表現
	 */
	public String toString() {
		return org.opengion.fukurou.util.ToString.title( this.getClass().getName() )
				.println( "VERSION"		,VERSION	)
				.println( "defaultVal"	,defaultVal	)
				.println( "command"		,command	)
				.println( "Other..."	,getAttributes().getAttribute() )
				.fixForm().toString() ;
	}
}
