/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.taglib;

import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.html.TableFormatter;

/**
 * ガントチャート（タスク配置型）用の繰り返しタグのフォーマットに使用します。
 *
 * itd タグは、ガントヘッダー部の TDタグの繰返しに使用されます。
 * この繰返しは、ganttParam タグの minDuration で指定された間隔で行われます。
 * (例えば、0.5 を指定すれば、半日単位で処理されます。)
 * itd タグの colspan 属性を指定した場合は、itd 自身が、td タグに colspan を
 * 追加すると共に、繰返し自身を、その指定数だけに抑制します。
 * 具体的には、colspan="2" とすると、２回に一回しか、itd タグが呼び出されなく
 * なります。
 *
 *
 * @og.formSample
 * ●使用例
 *    <og:thead rowspan="1">
 *      <tr>
 *        <og:itd>M/d</og:itd>
 *      </tr>
 *    </og:thead>
 *    <og:tbody rowspan="1" >
 *      <tr>
 *        <og:itd>
 *          <span class="cGntBar[!FGTASK]"
 *                title="[NMMCN]&amp;#13;&amp;#10;[NMKT]"
 *                val1 ="[GVZOOM]"
 *                val2 ="[CDJGS]"
 *                val3 ="[WC]"
 *                val4 ="[NOMCN]"
 *                val5 ="[CDKT]"
 *                val6 ="[FGTASK]"
 *                val7 ="[DYSTART]"
 *                val8 ="[DYDELAY]"
 *                val9 ="[DURATION]" >&nbsp;</span>
 *        </og:itd>
 *      </tr>
 *    </og:tbody>
 *
 *
 * @og.rev 3.5.4.8 (2004/02/23) 新規作成
 * @og.group 画面部品
 *
 * @version  4.0
 * @author	 Kazuhiko Hasegawa
 * @since    JDK5.0,
 */
public class ItdTag extends CommonTagSupport {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	private static final long serialVersionUID = 3562 ;	// 3.5.6.2 (2004/07/05)

	private String itdBody = null;

	/**
	 * Taglibの開始タグが見つかったときに処理する doStartTag() を オーバーライドします。
	 *
	 * @return  int
	 */
	@Override
	public int doStartTag() {
		return( EVAL_BODY_BUFFERED );	// Body を評価する。（ extends BodyTagSupport 時）
	}

	/**
	 * Taglibのタグ本体を処理する doAfterBody() を オーバーライドします。
	 *
	 * @return  int
	 */
	@Override
	public int doAfterBody() {
		itdBody = getBodyString();

		return(SKIP_BODY);				// Body を評価しない
	}

	/**
	 * Taglibの終了タグが見つかったときに処理する doEndTag() を オーバーライドします。
	 *
	 * @return  int
	 */
	@Override
	public int doEndTag() {
		debugPrint();		// 4.0.0 (2005/02/28)
		TFormatTag tFormat = (TFormatTag)findAncestorWithClass( this, TFormatTag.class );
		if( tFormat != null ) {
			tFormat.setItdBody( itdBody );
			jspPrint( TableFormatter.HYBS_ITD_MARKER );
		}
		else {
			String errMsg = "<b>このタグは、TheadTag か、TBodyTagの内側(要素)に記述してください。</b>";
			throw new HybsSystemException( errMsg );
		}

		return(EVAL_PAGE);		// ページの残りを評価する。
	}

	/**
	 * タグリブオブジェクトをリリースします。
	 * キャッシュされて再利用されるので、フィールドの初期設定を行います。
	 *
	 */
	@Override
	protected void release2() {
		super.release2();
		itdBody = null;
	}

	/**
	 * このオブジェクトの文字列表現を返します。
	 * 基本的にデバッグ目的に使用します。
	 *
	 * @return このクラスの文字列表現
	 */
	public String toString() {
		return org.opengion.fukurou.util.ToString.title( this.getClass().getName() )
				.println( "VERSION"		,VERSION	)
				.println( "itdBody"		,itdBody	)
				.println( "Other..."	,getAttributes().getAttribute() )
				.fixForm().toString() ;
	}
}
