/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hayabusa.io;

import java.awt.Graphics2D;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.data.category.CategoryDataset;

/**
 * <p>HybsDrawItem は、ChartPlot インターフェースを継承した実体クラスです。
 * JFreeChart では、XYPlot 関係の プロットを構築して、レンデラーや、データセットを
 * 設定していきます。
 * ここでは、複数のデータセットはサポートしていません。
 *
 * @version  0.9.0	2007/06/21
 * @author	 Kazuhiko Hasegawa
 * @since	 JDK1.1,
 */
public interface HybsDrawItem {

	/**
	 * drawItem と同等の機能を持った、高速版メソッドです。
	 *
	 * @og.rev 4.1.1.0 (2008/02/04) 新規追加
	 *
	 * @param g2			Graphics2D
	 * @param state			CategoryItemRendererState
	 * @param dataArea		Rectangle2D
	 * @param plot			CategoryPlot
	 * @param domainAxis	CategoryAxis
	 * @param rangeAxis		ValueAxis
	 * @param dataset		CategoryDataset
	 * @param serNo			int
	 */
	void drawItem2( final Graphics2D g2, final CategoryItemRendererState state,
			final Rectangle2D dataArea, final CategoryPlot plot, final CategoryAxis domainAxis,
			final ValueAxis rangeAxis, final CategoryDataset dataset, final int serNo ) ;

	/**
	 * itemLabelVisible 時に、最後の値のみ表示するかどうかを指定します。
	 *
	 * これは、itemLabelVisible 属性に、"last" という設定値を指定した場合は、
	 * 最後のみラベル表示します。
	 * このメソッドでは、true が指定された場合は、"last" 属性が有効になったと
	 * 判断します。
	 *
	 * @og.rev 4.1.2.0 (2008/03/12) 新規追加
	 *
	 * @param flag		boolean
	 */
	void setItemLabelLastVisible( boolean flag ) ;
}
