<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX003"
	title	= "対訳"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command = "{@command}" debug="false" maxRowCount="{@maxRowCount}">
	<jsp:text>
		select GENBUN,LANG_GEN,YAKU,LANG_YAKU,KBYAKU,ID,COMMENTS,UNIQ,FGJ
		from    GF28
	</jsp:text>
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "GENBUN    LIKE '{@GENBUN}%'"    />
		<og:and value = "LANG_GEN  LIKE '{@LANG_GEN}%'"  />
		<og:and value = "LANG_YAKU LIKE '{@LANG_YAKU}%'" />
		<og:and value = "KBYAKU    LIKE '{@KBYAKU}%'"    />
		<og:and value = "YAKU      LIKE '%{@YAKU}%'"     />
		<og:and value = "ID        LIKE '{@ID}%'"        />
		<og:and value = "FGJ in ( '0','1' )"             />
	</og:where>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@SORT}" defaultVal="GENBUN,KBYAKU" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->
<og:columnEditor column="GENBUN"    must="true" />
<og:columnEditor column="LANG_GEN"  must="true" />
<og:columnEditor column="LANG_YAKU" must="true" />
<og:columnEditor column="KBYAKU"    must="true" />

<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。 -->
<og:writeCheck>
	<og:submit  value="copy"     lbl="COPY"    accesskey="C" />
	<og:submit  value="modify"   lbl="MODIFY"  accesskey="M" />
	<og:submit  value="delete"   lbl="DELETE"  accesskey="D" />
	<og:submit  value="dupliDelete"  lbl="DUPLI" command="NEW" />
	<og:submit  value="yakuUpdate"   lbl="YAKU"  command="NEW" />

</og:writeCheck>

<og:equals val1="{@KBYAKU}" val2="3" >
<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTable"
	command 	 = "{@command}"
	noDisplay    = "UNIQ,FGJ"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
	rowspan      = "2"
>
<tr><td>[LANG_GEN]</td><td>[GENBUN]</td><td>[KBYAKU]</td><td>[ID]</td></tr>
<tr><td>[LANG_YAKU]</td><td>[YAKU]</td><td colspan="2">[COMMENTS]</td></tr>
</og:view>
</og:equals>

<og:equals val1="{@KBYAKU}" val2="3" notEquals="true" >
<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	noDisplay    = "UNIQ,FGJ"
	checked      = "{@checked}"
	startNo      = "{@startNo}" 
	pageSize     = "{@pageSize}"
/>
</og:equals>
</form>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
