<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select CASE KBSAKU WHEN '3' THEN '1' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
	</jsp:text>
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID   =  '{@SYSTEM_ID}'"     />
		<og:and value = "LANG        =  '{@LANG}'"          />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ColumnEditorTag は、指定のカラム属性を設定しなおします。 以下は、must属性を true にしています。 -->
<og:columnEditor column="LANG"      must="true" />
<og:columnEditor column="CLM"       must="true" size="20" />
<og:columnEditor column="NAME_JA"     size="20" must="true"/>
<og:columnEditor column="LABEL_NAME"  size="20" />

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GF9500" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,LANG,CLM,KBSAKU,IMAGE"
		vals="NEW,[SYSTEM_ID],[LANG],[CLM],[KBSAKU],true" />
	<og:link column="LABEL_NAME" href="{@SYS.FILE_OUT_URL}EXCEL/[CLM].xls" useGamenId="false" target="_NEW" />
</og:viewLink>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1" >
		<span style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="2" >
		<span style="background-color:#cc00ff">[NAME_JA]</span>
	</og:columnMarker>
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="3" >
		<span style="background-color:#00ccff">[NAME_JA]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- formタグでリクエストフィールドを囲います。oneClick()関数は、２重押し防止JavaScriptです。 -->
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 複写、変更、削除ボタンを作成します。value属性+.jspの画面に制御が移ります。 -->
<!-- このとき、command=(value属性の値の大文字)が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="update"   command="COPY"   lbl="COPY"    accesskey="C"
			keys="noWritable" vals="null" />
	<og:submit  value="update"   command="MODIFY" lbl="MODIFY"  accesskey="M" 
			keys="noWritable" vals="CLM" />
	<og:submit  value="update"   command="DELETE" lbl="DELETE"  accesskey="D" 
			keys="columnWritable" vals="null" />
	<og:submit  gamenId="GF9110" value="index" dbkeys="SYSTEM_ID,LANG,CLM" command="NEW" lbl="GF9100" target="CONTENTS" />
<br />
</og:writeCheck>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
