<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" >
	<script src="http://maps.google.com/maps?file=api&amp;v=2.x&amp;key=ABQIAAAA4QJBHnygq3nFxELEoanZIxQD-FUxLnYCHtX3JzoqWsRyvoeG9BQsIBT0v4oWfey-XsMi7cGFC9BbXw" type="text/javascript"><!-- --></script>
	<script src="googleMaps.js" type="text/javascript"><!-- --></script>
</og:head>

<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF7010"
	title	= "GoogleMap"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>


<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select POSTCODE,PREF_KANJI,JIGYO_KANJI,SJIGYO,
				ADDRESS1 || DECODE( INSTR1,0,ADDRESS2,
										SUBSTR( ADDRESS2,1,INSTR1-1 ) || 
										SUBSTR( ADDRESS2,INSTR2+1 ) ) as ADDRESS
		from (
			select POSTCODE,PREF_KANJI,
					JIGYO_KANJI,REPLACE( JIGYO_KANJI,'株式会社','(株)') as SJIGYO,
					trim(CITY_KANJI) || trim(TOWN_KANJI) as ADDRESS1,
					trim(BLOCK_KANJI) as ADDRESS2,
					INSTR(trim(BLOCK_KANJI),'（') as INSTR1,
					INSTR(trim(BLOCK_KANJI),'）') as INSTR2
			from GF42
	</jsp:text>
	<og:where>
		<og:and value = "JISCODE     like '{@PREF_CODE}%'"  />
		<og:and value = "POSTCODE    like '{@POSTCODE}%'"   />
		<og:and value = "CITY_KANJI  like '{@CITY_KANJI}%'" />
		<og:and value = "TOWN_KANJI  like '{@TOWN_KANJI}%'" />
		<og:and value = "JIGYO_KANJI like '{@JIGYO_KANJI}%'"  />
		<og:and value = "JIGYO_KANJI is not null"             />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "JISCODE,CITY_KANJI" />
	<jsp:text>
	)
	</jsp:text>
</og:query>

<og:columnEditor column="SJIGYO"  renderer="SLABEL" />
<og:columnEditor column="ADDRESS" renderer="LABEL" />

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<og:columnMarker column="SJIGYO" >
		<span onClick="showAddress([ROW.JSON]);">[SJIGYO]</span>
	</og:columnMarker>
</og:viewMarker>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->

<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	columnDisplay = "SJIGYO"
/>

<div id="map" style="position:relative; left:300px; width: 500px; height: 500px"></div>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>

