<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6050"
	title	= "ポップアップ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,LANG,CLM,NAME_JA,LABEL_NAME,AAA"
	nullCheck = "SYSTEM_ID"
/>

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="false" dbid="{@DBID}" trace="false" scope="request">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
	<jsp:text>
		select CASE KBSAKU WHEN '3' THEN '1' ELSE KBSAKU END AS WRITABLE,
				CLM,NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,FGJ
		from GF41
	</jsp:text>
	<og:where>
		<og:and value = "FGJ         in  ('0','1')"         />
		<og:and value = "SYSTEM_ID  =  '{@SYSTEM_ID}'"  />
		<og:and value = "LANG        like '{@LANG}%'"       />
		<og:and value = "CLM         like '{@CLM}%'"        />
		<og:and value = "NAME_JA     like '{@NAME_JA}%'"    />
		<og:and value = "LABEL_NAME  like '{@LABEL_NAME}%'" />
		<og:and value = "KBSAKU      =    '{@KBSAKU}'"      />
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- viewタグでpopupReturnKeysを設定するとポップアップ時に値を返します -->
<og:view
	viewFormType = "HTMLTable"
	command    = "{@command}"
	noDisplay  = "FGJ"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	useHilightRow = "true"
	scope      = "request"
	selectedType = "radio"
	popupReturnKeys = "SYSTEM_ID,CLM,NAME_JA"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
