<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:仕様書DB"
	pgid	= "GF2200"
	title	= "画面項目定義テーブル登録"
	date	= "2009/07/08"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<!-- 入力チェック -->
<!-- nullCheckの記述は不要です。columnのチェックを行う場合は、個別に記述する必要があります -->
<og:columnCheck command = "{@command}" />

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- SELECT 区のカラム列を取得します。 -->
<og:value command="SQL" action="ROW_APPEND" >
	select ZOKUSEI  as SELCLM
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'RESULT'
	and   ZOKUSEI	is not null
	order by SEQ
</og:value>
<!--
<og:value command="SQL" action="ROW_APPEND" >
	select case WHEN TBL IS NULL THEN '' ELSE TBL || '.' END || CLM as SELCLM
	from (
		select MIN(SEQ) AS XSEQ,MIN(TABLE_NAME) TBL, CLM
		from GF92 
		where SYSTEM_ID	= '{@SYSTEM_ID}'
		and   PGID		= '{@PGID}'
		and   NMSYORI	= 'RESULT'
		group by CLM
		order by MIN(SEQ)
	)
	order by XSEQ
</og:value>
-->

<!-- SELECT 区のカラム列が存在しない場合は、ここでSTOPする。 -->
<og:equals val1="{@SELCLM}" nullCheck="true" useStop="true" >
	<og:message lbl="MSG0077" />
</og:equals>

<!-- FROM 区のテーブル名を取得します。 -->
<og:value command="SQL" action="ROW_APPEND" >
	select TABLE_NAME as SELTBL
	from GF91
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   PGID		= '{@PGID}'
	group by TABLE_NAME
	order by TABLE_NAME
</og:value>

<!-- FROM 区のテーブル名が存在しない場合は、ここでSTOPする。 -->
<og:equals val1="{@SELTBL}" nullCheck="true" useStop="true" >
	<og:message lbl="MSG0077" />
</og:equals>

<!-- WHERE 区のうち、QUERYで指定した項目を取得します。 -->
<og:value command="SQL" action="ALL_LIST" >
	select CLM as WHCLM,TABLE_NAME as WHTBL
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'QUERY'
	order by SYSTEM_ID,PGID,NMSYORI,SEQ
</og:value>

<!-- WHERE 区のうち、JOINで指定した項目を取得します。 -->
<og:value command="SQL" action="ALL_LIST" >
	select CLM as JOCLM,TABLE_NAME as TBL_A,ZOKUSEI as TBL_B
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'JOIN'
	order by SYSTEM_ID,PGID,NMSYORI,SEQ
</og:value>

<!-- WHERE 区のうち、CONSTで指定した項目を取得します。 -->
<og:value command="SQL" action="ALL_LIST" >
	select CLM as CNCLM,TABLE_NAME as CNTBL,ZOKUSEI as CNVAL
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}' 
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'CONST'
	order by SYSTEM_ID,PGID,NMSYORI,SEQ
</og:value>

<!-- FROM 区のテーブル名を取得します。 -->
<og:value command="SQL" action="ROW_APPEND" >
	select ZOKUSEI as GRPCLM
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}'
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'GROUP_BY'
</og:value>

<og:chartCreate
	width		= "600"
	height		= "400"
>
	<og:chartDataset
		chartType	= "{@chartType}"
	>
			SELECT	{@SELCLM}
			FROM	{@SELTBL}
		<og:where>
			<c:if test="${fn:length(JOCLM) != 0}">
				<c:forEach var="i" begin="0" end="${fn:length(JOCLM)-1}" varStatus="status">
					<og:and value="${TBL_A[i]}.${JOCLM[i]} = ${TBL_B[i]}.${JOCLM[i]}" />
				</c:forEach>
			</c:if>
			<c:if test="${fn:length(CNCLM) != 0}">
				<c:forEach var="i" begin="0" end="${fn:length(CNCLM)-1}" varStatus="status">
					<og:and value="${CNTBL[i]}.${CNCLM[i]} ${CNVAL[i]}" />
				</c:forEach>
			</c:if>
			<c:if test="${fn:length(WHTBL) != 0}">
				<c:forEach var="i" begin="0" end="${fn:length(WHCLM)-1}" varStatus="status">
					<og:and value="${WHTBL[i]}.${WHCLM[i]} LIKE '{@${WHCLM[i]}}%'" />
				</c:forEach>
			</c:if>
		</og:where>
		<og:appear startKey = "GROUP BY" value = "{@GRPCLM}  " />	<!-- スペース必須 -->
		<og:appear startKey = "ORDER BY" value = "{@ORDER_BY}" />
	</og:chartDataset>
</og:chartCreate>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
