<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	xmlns:c="http://java.sun.com/jsp/jstl/core"
	xmlns:fn="http://java.sun.com/jsp/jstl/functions"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:仕様書DB"
	pgid	= "GF2200"
	title	= "画面項目定義テーブル登録"
	date	= "2009/07/08"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<og:value command="SQL" action="ALL_LIST" >
	select CLM AS CLMX, MUST AS MUSTX, DEFAULT_VAL
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}' 
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'QUERY'
	group by CLM,MUST,DEFAULT_VAL
	order by MIN(SEQ)
</og:value>

<form method="GET" action="forward.jsp" target="RESULT" onClick="timeSet();">

<og:hidden name="PGID" value="{@PGID}" />

<!-- 変更はここから -->
<c:if test="${fn:length(CLMX) != 0}">
  <!-- ２重ループ。カラムの横軸の数=４ 単位に廻す。 table タグをループに入れれば１行単位にテーブルが作成できる -->
<table summary="layout" >
  <c:forEach var="i" begin="0" end="${fn:length(CLMX)-1}" step="4" varStatus="status1">
	<tr>
		<!-- ２重ループ。開始から終了までを４つ分廻す。 -->
		<c:forEach var="j" begin="${status1.index}" end="${status1.index + 3}" varStatus="status2">
			<!-- ２重ループ。開始から終了までを４つ分廻す。 -->
			<c:if test="${fn:length(CLMX[j]) != 0}">
			  <og:column name="${CLMX[j]}" defaultVal="${DEFAULT_VAL[j]}" must="${MUSTX[j]}" />
			</c:if>
		</c:forEach>
	</tr>
  </c:forEach>
</table>
</c:if>

<og:value command="SQL" action="ALL_LIST" >
	select ZOKUSEI as ZOKU
	from GF92 
	where SYSTEM_ID	= '{@SYSTEM_ID}' 
	and   PGID		= '{@PGID}'
	and   NMSYORI	= 'ORDER'
	order by SYSTEM_ID,PGID,NMSYORI,SEQ
</og:value>

<og:queryButton>
	<!-- 表示順 -->
	<c:if test="${fn:length(ZOKU) != 0}">
		<og:select name="ORDER_BY" lbl="ORDER_BY">
			<c:forEach var="i" begin="0" end="${fn:length(ZOKU)-1}" varStatus="status">
				<og:option value="${ZOKU[i]}" lbls="${ZOKU[i]}" />
			</c:forEach>
		</og:select>
	</c:if>
</og:queryButton>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
