/**************************************************************************/
/* GF63 ( リソースマスタ定義 )                                            */
/*                                                                        */
/* Created : 2009/12/16 19:47:04                                          */
/**************************************************************************/
CREATE TABLE GF63 (
   RESOURCE_ID NUMERIC(9)                                            /* 10  リソースID     */
 , CDBUN       VARCHAR(3)                                            /* 20  分類コード     */
 , CDRSC       VARCHAR(20)                                           /* 30  リソースコード */
 , NAME_JA     VARCHAR(200)                                          /* 40  名称           */
 , FUNC        VARCHAR(2)                                            /* 50  役割           */
 , SU_LOAD     NUMERIC(5)                                            /* 60  負荷           */
 , CONTACTS    VARCHAR(100)                                          /* 70  連絡           */
 , PHONE       VARCHAR(15)                                           /* 80  電話           */
 , UNIQ        BIGINT                      NOT NULL PRIMARY KEY      /* 800 ユニークキー   */
 , FGJ         VARCHAR(1)      DEFAULT '1' NOT NULL                  /* 810 状態フラグ     */
 , DYSET       VARCHAR(14)                                           /* 820 登録日時       */
 , PGSET       VARCHAR(10)                                           /* 830 作成PG         */
 , PGPSET      VARCHAR(10)                                           /* 840 作成親PG       */
 , USRSET      VARCHAR(10)                                           /* 850 作成社員       */
 , DYUPD       VARCHAR(14)                                           /* 860 更新日時       */
 , PGUPD       VARCHAR(10)                                           /* 870 更新PG         */
 , PGPUPD      VARCHAR(10)                                           /* 880 更新親PG       */
 , USRUPD      VARCHAR(10)                                           /* 890 更新者         */
);

CREATE SEQUENCE GF63S01 ;


CREATE TRIGGER GF63T01 FOR GF63
  BEFORE INSERT 
  AS BEGIN 
    NEW.UNIQ = GEN_ID( GF63S01,1 );
  END; 


