<?xml version="1.0"  encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL02"
	title	= "グループマスタ管理"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID,GROUP_ID,ADDRESS,NAME_JA,KBNAME"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}" />

<!-- 社員マスタの存在チェック-->
<og:dataCheck command = "ENTRY" exist = "true">
	SELECT CASE WHEN [KBNAME]='0' THEN 1
 				WHEN INSTR([ADDRESS],'@')>0 THEN 1
				ELSE COUNT(*)
		   END
	FROM GE35 
	WHERE USERID=[ADDRESS] AND COALESCE(FGJ,'0') !='9'
</og:dataCheck>

<!-- グループマスタの存在チェック-->
<og:dataCheck command = "ENTRY" conditionKey="KBNAME" conditionList="1" >
	SELECT COUNT(*)
	FROM GE33 
	WHERE   SYSTEM_ID=[SYSTEM_ID] 
		AND GROUP_ID=[GROUP_ID]
		AND ADDRESS=[ADDRESS]
		AND KBNAME ='1'
		AND COALESCE(FGJ,'0') !='9'
</og:dataCheck>
<og:dataCheck command = "ENTRY" conditionKey="KBNAME" conditionList="0" >
	SELECT COUNT(*)
	FROM GE33
	WHERE   SYSTEM_ID=[SYSTEM_ID] 
		AND GROUP_ID=[GROUP_ID]
		AND KBNAME ='0'
		AND COALESCE(FGJ,'0') !='9'
</og:dataCheck>

<!-- 前画面のSQL文を実行する場合に、tableUpdate の queryType="JDBCTableUpdate"を指定します。-->
<!-- 通常は変更する必要はありません。 -->

<og:tableUpdate command="{@command}" queryType="JDBCTableUpdate">
	<jsp:text>{@SQL}</jsp:text>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
