<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	select
		CASE WHEN A.UNIQ < B.UNIQ THEN '0' ELSE '1' END AS WRITABLE ,
		B.SYSTEM_ID,B.CLM,
		CASE WHEN A.NAME_JA    != B.NAME_JA    THEN B.NAME_JA    ELSE '' END AS NAME_JA ,
		CASE WHEN A.CLS_NAME   != B.CLS_NAME   THEN B.CLS_NAME   ELSE '' END AS CLS_NAME ,
		CASE WHEN A.USE_LENGTH != B.USE_LENGTH THEN B.USE_LENGTH ELSE '' END AS USE_LENGTH ,
		CASE WHEN A.RENDERER   != B.RENDERER   THEN B.RENDERER   ELSE '' END AS RENDERER ,
		CASE WHEN A.EDITOR     != B.EDITOR     THEN B.EDITOR     ELSE '' END AS EDITOR ,
		CASE WHEN A.DBTYPE     != B.DBTYPE     THEN B.DBTYPE     ELSE '' END AS DBTYPE ,
		CASE WHEN A.KBSAKU     != B.KBSAKU     THEN B.KBSAKU     ELSE '' END AS KBSAKU ,
		B.KBSAKU
	from  GEA03 A inner join GEA03 B
	on    A.SYSTEM_ID = B.SYSTEM_ID
	and   A.CLM       = B.CLM
	and   A.UNIQ     != B.UNIQ
	where A.SYSTEM_ID = '{@SYSTEM_ID}'
	and   A.KBSAKU   != '0'
	and   B.KBSAKU   != '0'
	and   A.FGJ       = '1'
	and   B.FGJ       = '1'
	order by B.SYSTEM_ID,B.CLM
</og:query>

<og:value key="lblKey" value="D" />

<og:hidden name="SQL">
	DELETE FROM GEA03
	WHERE SYSTEM_ID = [SYSTEM_ID]
	AND   CLM       = [CLM]
</og:hidden>

<og:viewLink command="{@command}">
	<og:link column="CLM" gamenId="GE0003" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,CLM,KBSAKU"
		vals="NEW,[SYSTEM_ID],[CLM],[KBSAKU]" />
</og:viewLink>
