/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.process;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opengion.fukurou.process.AbstractProcess;
import org.opengion.fukurou.process.ChainProcess;
import org.opengion.fukurou.process.FileLineModel;
import org.opengion.fukurou.process.LineModel;
import org.opengion.fukurou.process.ParamProcess;
import org.opengion.fukurou.util.Argument;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.LogWriter;

public class Process_FileCopy
extends AbstractProcess
implements ChainProcess {
    private File tempFile = null;
    private String inPath = null;
    private String inEncode = null;
    private String outPath = null;
    private String outEncode = null;
    private boolean binary = false;
    private boolean changeCrLf = false;
    private boolean display = false;
    private int inPathLen = 0;
    private boolean isEquals = false;
    private int inCount = 0;
    private static final Map<String, String> mustProparty = new LinkedHashMap<String, String>();
    private static final Map<String, String> usableProparty;

    public Process_FileCopy() {
        super("org.opengion.fukurou.process.Process_FileCopy", mustProparty, usableProparty);
    }

    @Override
    public void init(ParamProcess paramProcess) {
        Argument argument = this.getArgument();
        this.inPath = argument.getProparty("inPath");
        this.outPath = argument.getProparty("outPath");
        this.inEncode = argument.getProparty("inEncode", System.getProperty("file.encoding"));
        this.outEncode = argument.getProparty("outEncode", System.getProperty("file.encoding"));
        this.binary = argument.getProparty("binary", this.binary);
        this.changeCrLf = argument.getProparty("changeCrLf", this.changeCrLf);
        this.display = argument.getProparty("display", this.display);
        this.inPathLen = this.inPath.length();
        boolean bl = this.isEquals = this.outPath == null || this.inPath.equalsIgnoreCase(this.outPath);
        if (this.binary) {
            if (!this.inEncode.equalsIgnoreCase(this.outEncode)) {
                String string = "\u30d0\u30a4\u30ca\u30ea\u30b3\u30d4\u30fc\u6642\u306b\u306f\u3001\u5165\u51fa\u529b\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u306f\u540c\u3058\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002" + CR + " inEncode=[" + this.inEncode + "] , outEncode=[" + this.outEncode + "]";
                throw new RuntimeException(string);
            }
            if (this.isEquals) {
                String string = "\u5165\u51fa\u529b\u304c\u540c\u3058\u30d5\u30a1\u30a4\u30eb\u306e\u30d0\u30a4\u30ca\u30ea\u30b3\u30d4\u30fc\u306f\u3067\u304d\u307e\u305b\u3093\u3002" + CR + " inPath=[" + this.inPath + "] , outPath=[" + this.outPath + "]";
                throw new RuntimeException(string);
            }
        }
        if (this.isEquals) {
            try {
                this.tempFile = File.createTempFile("X", ".tmp", new File(this.outPath));
                this.tempFile.deleteOnExit();
            }
            catch (IOException iOException) {
                String string = "\u4e2d\u9593\u30d5\u30a1\u30a4\u30eb\u4f5c\u6210\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + CR + " outPath=[" + this.outPath + "]";
                throw new RuntimeException(string, iOException);
            }
        }
    }

    @Override
    public void end(boolean bl) {
        this.tempFile = null;
    }

    @Override
    public LineModel action(LineModel lineModel) {
        Object object;
        ++this.inCount;
        FileLineModel fileLineModel = lineModel instanceof FileLineModel ? (FileLineModel)lineModel : new FileLineModel(lineModel);
        File file = fileLineModel.getFile();
        if (!file.isFile()) {
            if (this.display) {
                this.println(lineModel.dataLine());
            }
            return lineModel;
        }
        File file2 = new File(this.outPath, file.getAbsolutePath().substring(this.inPathLen));
        fileLineModel.setFile(file2);
        if (!this.isEquals) {
            this.tempFile = file2;
            object = file2.getParentFile();
            if (object != null && !((File)object).exists() && !((File)object).mkdirs()) {
                String string = "\u6240\u5b9a\u306e\u30d5\u30a9\u30eb\u30c0\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + object + "]";
                throw new RuntimeException(string);
            }
        }
        if (this.binary) {
            FileUtil.copy(file, this.tempFile, this.changeCrLf);
        } else {
            object = FileUtil.getBufferedReader(file, this.inEncode);
            PrintWriter printWriter = FileUtil.getPrintWriter(this.tempFile, this.outEncode);
            try {
                String string;
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    printWriter.println(string);
                }
            }
            catch (IOException iOException) {
                String string = "\u30d5\u30a1\u30a4\u30eb\u30b3\u30d4\u30fc\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002[" + lineModel.getRowNo() + "]\u4ef6\u76ee" + CR + " inFile=[" + file + "] , tempFile=[" + this.tempFile + "]";
                throw new RuntimeException(string, iOException);
            }
            finally {
                Closer.ioClose((Closeable)object);
                Closer.ioClose(printWriter);
            }
        }
        if (this.isEquals) {
            if (!file2.delete()) {
                object = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u524a\u9664\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + file2 + "]";
                throw new RuntimeException((String)object);
            }
            if (!this.tempFile.renameTo(file2)) {
                object = "\u6240\u5b9a\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u30ea\u30cd\u30fc\u30e0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002[" + this.tempFile + "]";
                throw new RuntimeException((String)object);
            }
        }
        if (this.display) {
            this.println(lineModel.dataLine());
        }
        return lineModel;
    }

    @Override
    public String report() {
        String string = "[" + this.getClass().getName() + "]" + CR + "\t" + "Copy Count : " + this.inCount + CR + "\t" + "inPath     : " + this.inPath + CR + "\t" + "inEncode   : " + this.inEncode + CR + "\t" + "outPath    : " + this.outPath + CR + "\t" + "outEncode  : " + this.outEncode + CR + "\t" + "binary     : " + this.binary;
        return string;
    }

    @Override
    public String usage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Process_FileCopy \u306f\u3001\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel\u3092\u51e6\u7406\u3059\u308b\u3001").append(CR);
        stringBuilder.append("ChainProcess \u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u306e\u5b9f\u88c5\u30af\u30e9\u30b9\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u4e0a\u6d41\u304b\u3089\u53d7\u3051\u53d6\u3063\u305f FileLineModel \u306e \u30d5\u30a1\u30a4\u30eb\u304b\u3089\u3001inPath \u306e\u5171\u901a\u30d1\u30b9").append(CR);
        stringBuilder.append("\u4ee5\u4e0b\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u3001outPath \u306e\u5171\u901a\u30d1\u30b9\u4ee5\u4e0b\u306b\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002").append(CR);
        stringBuilder.append("\u30b3\u30d4\u30fc\u306e\u7a2e\u985e\u306f\u3001\u30d0\u30a4\u30ca\u30ea\u304b\u3001\u30c6\u30ad\u30b9\u30c8\u3067\u3001\u30c6\u30ad\u30b9\u30c8\u306e\u5834\u5408\u306f\u3001\u30a8\u30f3\u30b3\u30fc\u30c9").append(CR);
        stringBuilder.append("\u5909\u63db\u3082\u884c\u3046\u3053\u3068\u304c\u53ef\u80fd\u3067\u3059\u3002").append(CR);
        stringBuilder.append("inPath \u3068 outPath \u304c\u540c\u3058\u3001\u307e\u305f\u306f\u3001outPath \u304c\u672a\u8a2d\u5b9a\u306e\u5834\u5408\u306f\u3001\u5165\u529b\u3068\u51fa\u529b\u304c").append(CR);
        stringBuilder.append("\u540c\u3058\u3067\u3059\u306e\u3067\u3001\u81ea\u5206\u81ea\u8eab\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u5909\u63db\u51e6\u7406\u3092\u884c\u3046\u3053\u3068\u306b\u306a\u308a\u307e\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u30b3\u30d4\u30fc\u3055\u308c\u308b\u30d5\u30a1\u30a4\u30eb\u306e\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u3001\u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d\u3068\u540c\u4e00\u3067\u3059\u3002\u4fdd\u5b58\u3055\u308c\u308b").append(CR);
        stringBuilder.append("\u30d5\u30a9\u30eb\u30c0\u304c\u7570\u306a\u308a\u307e\u3059\u3002(\u540c\u4e00\u306b\u3059\u308b\u3053\u3068\u3082\u53ef\u80fd\u3067\u3059\u3002)").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u4e0a\u6d41\u30d7\u30ed\u30bb\u30b9\u3067\u306f\u3001Name \u5c5e\u6027\u3068\u3057\u3066\u3001\u300eFile\u300f\u3092\u6301\u3061\u3001\u5024\u306f\u3001File\u30aa\u30d6\u30b8\u30a7\u30af\u30c8").append(CR);
        stringBuilder.append("\u3067\u3042\u308b\u3001Process_FileSearch \u3092\u4f7f\u7528\u3059\u308b\u306e\u304c\u3001\u4fbf\u5229\u3067\u3059\u3002\u305d\u308c\u4ee5\u5916\u306e\u30af\u30e9\u30b9\u3092").append(CR);
        stringBuilder.append("\u4f7f\u7528\u3059\u308b\u5834\u5408\u3067\u3082\u3001Name\u5c5e\u6027\u3068\u3001File \u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u6301\u3064 LineModel \u3092\u53d7\u3051\u6e21\u3057").append(CR);
        stringBuilder.append("\u3067\u304d\u308c\u3070\u3001\u4f7f\u7528\u53ef\u80fd\u3067\u3059\u3002").append(CR);
        stringBuilder.append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u4e2d\u306b\u7a7a\u767d\u3092\u542b\u3080\u5834\u5408\u306f\u3001\u30c0\u30d6\u30eb\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3(\"\") \u3067\u62ec\u3063\u3066\u4e0b\u3055\u3044\u3002").append(CR);
        stringBuilder.append("\u5f15\u6570\u6587\u5b57\u5217\u306e \u300e=\u300f\u306e\u524d\u5f8c\u306b\u306f\u3001\u7a7a\u767d\u306f\u631f\u3081\u307e\u305b\u3093\u3002\u5fc5\u305a\u3001-key=value \u306e\u69d8\u306b").append(CR);
        stringBuilder.append("\u7e4b\u3052\u3066\u304f\u3060\u3055\u3044\u3002").append(CR);
        stringBuilder.append(CR).append(CR);
        stringBuilder.append(this.getArgument().usage()).append(CR);
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        LogWriter.log(new Process_FileCopy().usage());
    }

    static {
        mustProparty.put("inPath", "\u30b3\u30d4\u30fc\u5143\u306e\u30d5\u30a1\u30a4\u30eb\u57fa\u6e96\u30d1\u30b9");
        usableProparty = new LinkedHashMap<String, String>();
        usableProparty.put("inEncode", "\u30b3\u30d4\u30fc\u5143\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7");
        usableProparty.put("outPath", "\u30b3\u30d4\u30fc\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u57fa\u6e96\u30d1\u30b9");
        usableProparty.put("outEncode", "\u30b3\u30d4\u30fc\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u30a8\u30f3\u30b3\u30fc\u30c9\u30bf\u30a4\u30d7");
        usableProparty.put("binary", "true\u306f\u3001\u30d0\u30a4\u30ca\u30ea\u30d5\u30a1\u30a4\u30eb\u3092\u30b3\u30d4\u30fc\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1afalse\uff09");
        usableProparty.put("changeCrLf", "true\u306f\u3001\u30d0\u30a4\u30ca\u30ea\u30d5\u30a1\u30a4\u30eb\u306e\u30b3\u30d4\u30fc\u6642\u306bCR+LF\u306b\u5909\u63db\u3057\u307e\u3059(\u521d\u671f\u5024\uff1afalse\uff09");
        usableProparty.put("display", "true\u306f\u3001\u30b3\u30d4\u30fc\u72b6\u6cc1\u3092\u8868\u793a\u3057\u307e\u3059\u3002(\u521d\u671f\u5024\uff1afalse\uff09");
    }
}

