/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.io;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

class HeaderData {
    private String[] names;
    private int[] index;
    private int columnSize = 0;
    private boolean nameNoSet = true;

    HeaderData() {
    }

    boolean isSkip(Row row) {
        if (row == null) {
            return true;
        }
        short s = row.getFirstCellNum();
        Cell cell = row.getCell((int)s);
        String string = this.getValue(cell);
        if (string != null && string.length() > 0) {
            if (this.nameNoSet) {
                if (string.equalsIgnoreCase("#Name")) {
                    this.makeNames(row);
                    this.nameNoSet = false;
                    return true;
                }
                if (string.charAt(0) == '#') {
                    return true;
                }
                String string2 = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002" + HybsSystem.CR + "\u53ef\u80fd\u6027\u3068\u3057\u3066\u3001\u30d5\u30a1\u30a4\u30eb\u304c\u3001\u30cd\u30a4\u30c6\u30a3\u30d6Excel\u3067\u306a\u3044\u4e8b\u304c\u8003\u3048\u3089\u308c\u307e\u3059\u3002" + HybsSystem.CR;
                throw new HybsSystemException(string2);
            }
            if (string.charAt(0) == '#') {
                return true;
            }
        }
        return this.nameNoSet;
    }

    private void makeNames(Row row) {
        int n = row.getFirstCellNum();
        short s = row.getLastCellNum();
        int n2 = s - n;
        String[] stringArray = new String[n2];
        int[] nArray = new int[n2];
        for (int i = n = (short)(n + 1); i <= s; ++i) {
            Cell cell = row.getCell(i);
            String string = this.getValue(cell);
            if (string == null || string.length() <= 0) continue;
            stringArray[this.columnSize] = string;
            nArray[this.columnSize] = i;
            ++this.columnSize;
        }
        if (n2 == this.columnSize) {
            this.names = stringArray;
            this.index = nArray;
        } else {
            this.names = new String[this.columnSize];
            this.index = new int[this.columnSize];
            System.arraycopy(stringArray, 0, this.names, 0, this.columnSize);
            System.arraycopy(nArray, 0, this.index, 0, this.columnSize);
        }
    }

    String[] getNames() {
        return this.names;
    }

    int getColumnSize() {
        return this.columnSize;
    }

    String[] row2Array(Row row) {
        if (this.nameNoSet) {
            String string = "#NAME \u304c\u898b\u3064\u304b\u308b\u524d\u306b\u30c7\u30fc\u30bf\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\u3002";
            throw new HybsSystemException(string);
        }
        String[] stringArray = new String[this.columnSize];
        for (int i = 0; i < this.columnSize; ++i) {
            Cell cell = row.getCell(this.index[i]);
            stringArray[i] = this.getValue(cell);
        }
        return stringArray;
    }

    private String getValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        String string = "";
        int n = cell.getCellType();
        switch (n) {
            case 0: {
                string = this.getNumericTypeString(cell);
                break;
            }
            case 1: {
                RichTextString richTextString = cell.getRichStringCellValue();
                if (richTextString == null) break;
                string = richTextString.getString();
                break;
            }
            case 2: {
                RichTextString richTextString = cell.getRichStringCellValue();
                if (richTextString != null) {
                    string = richTextString.getString();
                    break;
                }
                string = this.getNumericTypeString(cell);
                break;
            }
            case 4: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 3: 
            case 5: {
                break;
            }
        }
        return string.trim();
    }

    private String getNumericTypeString(Cell cell) {
        String string;
        double d = cell.getNumericCellValue();
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.JAPAN);
            string = simpleDateFormat.format(DateUtil.getJavaDate((double)d));
        } else {
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (numberFormat instanceof DecimalFormat) {
                ((DecimalFormat)numberFormat).applyPattern("#.####");
            }
            string = numberFormat.format(d);
        }
        return string;
    }
}

