/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.hsqldb;

import java.io.UnsupportedEncodingException;

/**
 * HSQLDB用の拡張組込み関数です。
 *
 * @og.group HSQLDB
 *
 * @version  4.0
 * @author   Hiroki Nakamura
 * @since    JDK6.0,
 */
public class ExtendedFunction {
  
	private static final long serialVersionUID = 4370;
  
	private static final String CR = System.getProperty("line.separator");

    private static final String ENCODE = "UTF-8";

	/**
	 * substr関数のバイト数版
	 *
     * @param	value	     変換する文字列
	 * @param	start		 変換開始アドレス
	 * @param	length		 変換バイト数
	 * @return	変換後文字列
	 */
	public static String substrb( final String value, final int start, final int length ) throws UnsupportedEncodingException {
		String rtn = null;
        byte[] byteValue = makeByte( value );
		if( byteValue != null ) {
				rtn = new String( byteValue,start-1,length,ENCODE );
		}
		return rtn;
	}

  	/**
	 * length関数のバイト数版
	 *
	 * @param	value       バイト数をカウントする文字列
	 * @return  バイト数
	 */
	public static int lengthb( final String value ) throws UnsupportedEncodingException {
		return makeByte( value ).length;
	}

  	/**
	 * 指定の文字列をバイトコードに変換します。
	 * 引数の文字列が null の場合は、return は、byte[0] を返します。
	 *
	 * @param	value	 変換するストリング値
	 * @param	encode	 変換する文字エンコード
	 * @return	変換後文字列
	 */
	private static byte[] makeByte( final String value ) throws UnsupportedEncodingException {
		byte[] rtnByte = new byte[0];
		if( value != null ) {
			rtnByte = value.getBytes( ENCODE );
		}
		return rtnByte;
	}
}
