/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.table;

/**
 * <p>TableFilter_TABLE_SQLSERVER は、TableUpda インターフェースを継承した、DBTableModel 処理用の
 * 実装クラスです。とくに、SQLServer用のDB定義スクリプトを作成します。<br />
 *
 * ここでは、テーブル一覧の検索結果より、GF05 のテーブルカラム定義テーブルから
 * 必要な情報を取得し、テーブル作成スクリプトを作成します。
 * 出力ファイルは、テーブル名＋"S.sql" という命名規則で作成します。
 * 検索では、(SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,INITIAL_EXTENT,NEXT_EXTENT,COMMENTS)
 * の項目を取得する必要があります。
 *
 * @version  0.9.0  2000/10/17
 * @author   Kazuhiko Hasegawa
 * @since    JDK1.1,
 */
public class TableFilter_TABLE_SQLSERVER extends TableFilter_TABLE {
	//* このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "4.0.0 (2005/08/31)" ;

	protected String[] makeLineList( final String[] data,final boolean first ) {

		String clsName = data[GF05_CLS_NAME] ;

		data[GF05_NAME_JA] = null;

		if( "UNIQ".equalsIgnoreCase( data[GF05_CLM] ) || "UNIQSEQ".equalsIgnoreCase( data[GF05_CLM] ) ) {
			data[GF05_CLS_NAME]     = "int IDENTITY(1,1)";
			data[GF05_DATA_DEFAULT] = null;
			data[GF05_NOT_NULL]     = null;
			data[GF05_USE_LENGTH]   = null;
		}
		else if( clsName == null || clsName.length() == 0 || clsName.startsWith( "VARCHAR" ) ) {
			data[GF05_CLS_NAME] = "varchar" ;
		}
		else if( clsName.startsWith( "CLOB" ) ) {
			data[GF05_CLS_NAME]     = "text";
			data[GF05_DATA_DEFAULT] = null;
			data[GF05_NOT_NULL]     = null;
			data[GF05_USE_LENGTH]   = null;
		}
		else if( clsName.startsWith( "DATE" ) ) {
			data[GF05_CLS_NAME]     = "datetime";
			data[GF05_DATA_DEFAULT] = null;
			data[GF05_NOT_NULL]     = null;
			data[GF05_USE_LENGTH]   = null;
		}
		else if( clsName.startsWith( "NUMBER" ) || clsName.startsWith( "LONG" ) ) {
			String len = data[GF05_USE_LENGTH] ;
			if( len.indexOf( ',' ) >= 0 ) {		// カンマがある
				data[GF05_CLS_NAME] = "decimal";
				data[GF05_USE_LENGTH] = null;
			}
			else if( Integer.parseInt( len ) >= 10 ) {	// １０桁以上
				data[GF05_CLS_NAME] = "float";
				data[GF05_USE_LENGTH] = null;
			}
			else {
				data[GF05_CLS_NAME] = "int";
				data[GF05_USE_LENGTH] = null;
			}
		}

		return super.makeLineList( data,first );
	}

	protected String makeEndLine( final int[] clmNo,final String[] data ) {
		return ( isXml ? ")" + EXEC_END_TAG : ");" );
	}

	protected String makeUniqSeq( final int[] clmNo,final String[] data ) {
		return "";
	}

	protected String makeUniqTrig( final int[] clmNo,final String[] data, final String uniqName ) {
		return "";
	}
}
