/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.db;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;

/**
 * JAXBで自動生成されたDBIDクラスを拡張したクラスです。
 * （継承しているわけではない）
 * <BR>
 * 以下の属性が追加されています。<BR>
 * dbProductName<BR>
 * dbProductVersion<BR>
 * driverName<BR>
 * driverVersion<BR>
 *
 * @og.rev 4.0.0 (2007/10/25) 新規作成
 *
 * @version  4.0
 * @author	 高橋正和
 * @since	 JDK5.0,
 */
public class EDbid {

	private 	String	dbidKey			= "DEFAULT";
	private 	String	url				= null;
	private 	String	user			= null;
	private 	String	password		= null;
	private 	boolean	readonly		= false;
	private 	int		mincount		= 3;
	private 	int		maxcount		= 30;
	private 	int		pooltime		= 3000;
	private 	boolean	isUseAppInfo	= true;

	private 	String	dbProductName	= null;
	private 	String	dbProductVersion= null;
	private 	String	driverName		= null;
	private 	String	driverVersion	= null;

	/**
	 * dbProductNameの取得
	 *
	 * @return String
	 */
	public String getDbProductName() {
		return dbProductName;
	}

	/**
	 * dbProductVersionの取得
	 *
	 * @return String
	 */
	public String getDbProductVersion() {
		return dbProductVersion;
	}

	/**
	 * driverNameの取得
	 *
	 * @return String
	 */
	public String getDriverName() {
		return driverName;
	}

	/**
	 * driverVersionの取得
	 *
	 * @return String
	 */
	public String getDriverVersion() {
		return driverVersion;
	}

	/**
	 * dbidKeyの取得
	 *
	 * 内部的には、大文字のみで管理します。
	 *
	 * @return String
	 */
	public String getDbidKey() {
		return dbidKey;
	}

	/**
	 * dbidKeyの設定
	 *
	 * 内部的には、大文字のみで管理します。
	 *
	 * @og.rev 4.1.0.1 (2008/01/21) 登録時に、大文字に変換する。
	 *
	 * @param value
	 */
	protected void setDbidKey( final String value ) {
		if( value != null ) { dbidKey = value.toUpperCase( Locale.JAPAN ); }
	}

	/**
	 * urlの取得
	 *
	 * @return String
	 */
	public String getUrl() {
		return url;
	}

	/**
	 * urlの設定
	 *
	 * @param value
	 */
	protected void setUrl( final String value ) {
		if( value != null ) { url = value; }
	}

	/**
	 * userの取得
	 *
	 * @return String
	 */
	public String getUser() {
		return user;
	}

	/**
	 * userの設定
	 *
	 * @param value
	 */
	protected void setUser( final String value ) {
		if( value != null ) { user = value; }
	}

	/**
	 * passwordの取得
	 *
	 * @return String
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * passwordの設定
	 *
	 * @param value
	 */
	protected void setPassword( final String value ) {
		if( value != null ) { password = value; }
	}

	/**
	 * readonlyの取得
	 *
	 * @return boolean
	 */
	public boolean isReadonly() {
		return readonly ;
	}

	/**
	 * readonlyの設定
	 *
	 * @param value Boolean
	 */
	protected void setReadonly( final Boolean value ) {
		if( value != null ) { readonly = value.booleanValue(); }
	}

	/**
	 * mincountの取得
	 *
	 * @return int
	 */
	public int getMincount() {
		return mincount;
	}

	/**
	 * mincountの設定
	 *
	 * @param value Integer
	 */
	protected void setMincount( final Integer value ) {
		if( value != null ) { mincount = value.intValue(); }
	}

	/**
	 * maxcountの取得
	 *
	 * @return int
	 */
	public int getMaxcount() {
		return maxcount;
	}

	/**
	 * maxcountの設定
	 *
	 * @param value Integer
	 */
	protected void setMaxcount( final Integer value ) {
		if( value != null ) { maxcount = value.intValue(); }
	}

	/**
	 * pooltimeの取得
	 *
	 * @return int
	 */
	public int getPooltime() {
		return pooltime;
	}

	/**
	 * pooltimeの設定
	 *
	 * @param value Integer
	 */
	protected void setPooltime( final Integer value ) {
		if( value != null ) { pooltime = value.intValue(); }
	}

	/**
	 * isUseAppInfoの取得
	 *
	 * @return boolean
	 */
	public boolean isApplicationInfo() {
		return isUseAppInfo ;
	}

	/**
	 * isUseAppInfoの設定
	 *
	 * @param value Boolean
	 */
	protected void setApplicationInfo( final Boolean value ) {
		if( value != null ) { isUseAppInfo = value.booleanValue(); }
	}

	/**
	 * メタデータを受け取って
	 * dbProductName,dbProductVersion,driverName,driverVersion
	 * を一括で設定します
	 *
	 * @og.rev 4.0.0.0 (2007/10/30) 保持情報オブジェクト化に伴う変更
	 *
	 * @param meta
	 * @throws SQLException
	 */
	public void setMetaDataInfo( final DatabaseMetaData meta ) throws SQLException {
		dbProductName	= meta.getDatabaseProductName() ;
		dbProductVersion= meta.getDatabaseProductVersion() ;
		driverName		= meta.getDriverName() ;
		driverVersion	= meta.getDriverVersion() ;

		isUseAppInfo	= isUseAppInfo && "ORACLE".equalsIgnoreCase( dbProductName ) ;
	}

	public String toString() {
		final String CR = System.getProperty( "line.separator" );
		final StringBuilder buf = new StringBuilder();
		buf.append( "DBID=[" ).append( dbidKey ).append( "]," );
		buf.append( "URL =[" ).append( url     ).append( "]," );
		buf.append( "USER=[" ).append( user    ).append( "]," );
		buf.append( CR );
		buf.append( "MAXCOUNT=[" ).append( maxcount ).append( "]," );
		buf.append( "MINCOUNT=[" ).append( mincount ).append( "]," );
		buf.append( "POOLTIME=[" ).append( pooltime ).append( "]," );
		buf.append( "READONLY=[" ).append( readonly ).append( "]," );
		buf.append( "APPINFO=["  ).append( isUseAppInfo ).append( "]," );
		buf.append( CR );
		buf.append( "DB Product=[" ).append( dbProductName );
		buf.append( "(" ).append( dbProductVersion ).append( ")" ).append( "]" );
		buf.append( CR );
		buf.append( "DB Driver =[" ).append( driverName );
		buf.append( "(" ).append( driverVersion ).append( ")" ).append( "]" );
		buf.append( CR );
		return buf.toString();
	}
}
