<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />
<jsp:directive.page isErrorPage = "true" />
<jsp:scriptlet>
	ErrorData err = pageContext.getErrorData();
	String url = request.getContextPath() + "/jsp/";
	int statusCode = err.getStatusCode();

	// 401の場合はコードを送る必要がある
	if( statusCode == 401 ){
		response.addHeader("WWW-Authenticate", "BASIC realm=\"Web App\"");
		response.setStatus(statusCode);
	}
</jsp:scriptlet>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="Content-Style-Type" content="text/css" />
<og:text>
    <title>{@SESSION.GUI_TITLE}</title>
</og:text>
<style type="text/css">
	html {
		width: 100%;
		height: 100%;
	}
	body {
		font-family: "MS UI Gothic","ＭＳ Ｐゴシック",sans-serif;
		vertical-align:		middle ;
		margin: 0px; padding: 0px;
		letter-spacing: 0;
		background-color: #ffffff;
		color: rgb(64,75,114);
		width: 100%;
		height: 100%;
	}
	#time{
		text-align:right;
		color: #ee7777;
	}
	#msg{
		text-align:center;
	}
</style>
</head>
<body>
<div id="time">
	<og:text value="{@SYS.DATE}" />
</div>


<div id="msg">
<jsp:scriptlet>
	if( statusCode == 401 ){
		out.println("認証に失敗しました。");
	}
	else if( statusCode == 403 || statusCode ==404 ){
		out.println("画面が存在しないか、アクセス権限がありません。");
	}
	else{
		out.println("エラーです。システム管理者にご連絡下さい。");
	}
</jsp:scriptlet>
</div>

<pre>
<og:error viewMsgType="ALLNONE" />
</pre>

</body></html>
</jsp:root>
