<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF6070"
	title	= "クロス集計"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "CUBE_X,CUBE_Y"
/>

<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
		SELECT SUBSTRB(JOB,1,2) AS JOBKEY,
				{@CUBE_X},{@CUBE_Y},SUM(SAL) AS KEI,COUNT(*) AS SU
		FROM EMP,DEPT
		WHERE EMP.DEPTNO = DEPT.DEPTNO
		GROUP BY {@CUBE_X},{@CUBE_Y}
		ORDER BY {@CUBE_X},{@CUBE_Y}
	</jsp:text>
</og:query>

<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLCrossTable" 
	command    = "{@command}" 
	checked    = "{@checked}"
	startNo    = "{@startNo}" 
	pageSize   = "{@pageSize}" 
	useParam   = "true"
	noDisplay  = "KEI,SU"
>
	<og:crossParam
		cubeXColumn    = "{@CUBE_X}"
		cubeYColumn    = "{@CUBE_Y}"
		sumNumber      = "2"
		gokeiLabel     = " "
		saveTableId    = "DEFAULT"
		cubeSortType   = "{@cubeSortType}"
		gokeiSortDir   = "{@gokeiSortDir}"
	/>
</og:view>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
