<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:仕様書DB"
	pgid	= "GF2200"
	title	= "画面項目定義テーブル登録"
	date	= "2009/07/08"
	author	= "K.Hasegawa"
	text	= ""
	version	= "001"
/>

<!-- データが選ばれていなければエラー -->
<og:columnCheck command="{@command}" >
	<jsp:directive.include file="/jsp/common/history_back.jsp" />
</og:columnCheck>

<!-- forward.jsp から command がセットされて遷移してきます。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command = "{@command}" >
	<og:columnSet command="{@command}" columnId="SYSTEM_ID" action="NULLSET" value="{@MEM.SYSTEM_ID}" />
	<og:columnSet command="{@command}" columnId="PGID"      action="NULLSET" value="{@MEM.PGID}" />
</og:entry>

<og:message command="{@command}" /><br />
<form onSubmit="return oneClick();" method="POST" action="forward.jsp" target="RESULT">

<!-- 登録、取消、リセットボタンと、EXCEL(CSV)変更リンクを作成します。 -->
<!-- value属性+.jspの画面に制御が移ります。ただし、value="reset"のみ特殊で、result.jspに遷移します。 -->
<!-- commandには value属性の値の大文字が設定されます。 command属性で設定しなおすことも出来ます。-->
<og:writeCheck>
	<og:submit  value="entry" lbl="ENTRY" accesskey="E" />
	<og:submit  value="reset" lbl="RESET" accesskey="R" />
	<og:input type="reset"  name="command"  lbl="MSG0011"  td="false" />
<br />
</og:writeCheck>

<!-- 入力画面を表示します。 -->
<!-- columnWritable、または noWritable属性でカラムへの入力可／不可を指定します。 -->
<og:view
	viewFormType	= "HTMLTable"
	command			= "{@command}"
	noWritable		= "{@noWritable}"
	noDisplay		= "UNIQ,FGJ"
	columnWritable	= "{@columnWritable}"
	checked			= "{@checked}"
	startNo			= "{@startNo}"
	pageSize		= "{@pageSize}" />

<og:hidden name="sqlType" defaultVal="{@command}" value="{@sqlType}" />

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
