<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2140"
	title	= "DBスクリプト作成"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<og:columnCheck
	command   = "{@command}"
	nullCheck = "SYSTEM_ID,TBLSYU"
/>

<og:equals val1="{@TABLE}" val2="true" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		<jsp:text>
			select SYSTEM_ID,TBLSYU,TABLE_NAME,NAME_JA,TABLESPACE_NAME,INITIAL_EXTENT,NEXT_EXTENT,COMMENTS
			from GF02
			where SYSTEM_ID = '{@SYSTEM_ID}'
			and   TBLSYU    = '{@TBLSYU}'
			and   FGJ       = '1'
		</jsp:text>
		<og:where startKey="and">
			<og:and value="TABLE_NAME like '{@NAME}%'" />
		</og:where>
		<jsp:text>
			order by TABLE_NAME
		</jsp:text>
	</og:query>

	<og:link gamenId="GF2010" href="index.jsp" target="CONTENTS" 
		keys="SYSTEM_ID,TBLSYU,FGJ,TABLE_NAME,command" vals="{@SYSTEM_ID},{@TBLSYU},1,{@NAME},NEW" >
	Table Column <og:value command="GET" key="DB.COUNT" /> Created.
	</og:link>

	<og:tableFilter classId="TABLE{@TYPE}" keys="dir,XML" vals="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@USER.ID}/TABLE,{@XML}" />

<og:text>xml {@XML}</og:text>
</og:equals>

<og:equals val1="{@INDEX}" val2="true" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		<jsp:text>
			select A.SYSTEM_ID,A.TBLSYU,A.TABLE_NAME,B.NAME_JA AS TABLE_LABEL,A.INDEX_NAME,A.NAME_JA,A.INDTYPE,
					A.TABLESPACE_NAME,A.INITIAL_EXTENT,A.NEXT_EXTENT
			from GF06 A left outer join GF02 B
			on      A.SYSTEM_ID  = B.SYSTEM_ID
			and     A.TBLSYU     = B.TBLSYU
			and     A.TABLE_NAME = B.TABLE_NAME
			and     B.FGJ        = '1'
			where A.SYSTEM_ID = '{@SYSTEM_ID}'
			and   A.TBLSYU    = '{@TBLSYU}'
			and   A.FGJ       = '1'
		</jsp:text>
		<og:where startKey="and">
			<og:and value="A.TABLE_NAME like '{@NAME}%'" />
		</og:where>
		<jsp:text>
			order by A.TABLE_NAME,A.INDTYPE,A.INDEX_NAME
		</jsp:text>
	</og:query>

	<og:link gamenId="GF2030" href="index.jsp" target="CONTENTS" 
		keys="SYSTEM_ID,TBLSYU,FGJ,TABLE_NAME,command" vals="{@SYSTEM_ID},{@TBLSYU},1,{@NAME},NEW" >
	Index Column <og:value command="GET" key="DB.COUNT" /> Created.
	</og:link>

	<og:tableFilter classId="INDEX{@TYPE}" keys="dir,XML" vals="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@USER.ID}/INDEX,{@XML}" />
</og:equals>

<og:equals val1="{@ARG}" val2="true" >
	<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		<jsp:text>
			select OBJ_NAME,CLM,CLS_NAME,USE_LENGTH,CLM_NAME
			from GF81
			where SYSTEM_ID = '{@SYSTEM_ID}'
			and   TBLSYU    = '{@TBLSYU}'
			and   FGJ       = '1'
		</jsp:text>
		<og:where startKey="and">
			<og:and value="OBJ_NAME like '{@NAME}%'" />
		</og:where>
		<og:equals val1="{@CDKH}" val2="{@CDKH}">
			<jsp:text>
				and exists (select 'X' from GF81 B
							where B.SYSTEM_ID = GF81.SYSTEM_ID
							and   B.TBLSYU    = GF81.TBLSYU
							and   B.FGJ       = '1'
							and   B.OBJ_NAME  = GF81.OBJ_NAME
							and   B.CDKH      = '{@CDKH}' )
			</jsp:text>
		</og:equals>
		<jsp:text>
			order by OBJ_NAME,SEQNO
		</jsp:text>
	</og:query>

	<og:tableFilter classId="DBARG_OUT" keys="dir,XML" vals="{@SYS.REAL_PATH}{@SYS.FILE_URL}{@USER.ID}/ARG,{@XML}" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
