<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "DOC19"
	title	= "作成区分メンテ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- エラー時の戻るボタン。書き換えないで下さい。-->
<!-- history.back() で戻るボタンを表示します。	-->
<jsp:directive.include file="/jsp/common/history_back.jsp" />

<!-- command="ENTRY"時は、nullCheck のみ有効です。カラムに付いては、全カラムをチェックしています。-->
<og:columnCheck
	minRowCount	= "1"
	command		= "{@command}"
/>

<!-- command="ENTRY"時は、リクエスト情報（カラム名__行番号)を、DBTableModelにセットします。-->
<!-- カラムに対して値をセットしない場合、ColumnSetTagは不要です。 -->
<og:entry command="{@command}"  />

<!-- カラムをアップデートします -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate">
	<og:text>
		UPDATE	GEA03 A
		SET		FGLOAD		=	'1'
		WHERE	EXISTS ( SELECT 'x' FROM GF79 B
						 WHERE B.SOURCE		= [SOURCE]
						 AND B.SYSTEM_ID	= '{@MEM.SYSTEM_ID}'
						 AND A.CLM			= B.NAME )
		AND		A.FGJ		=			'1'
		AND		A.SYSTEM_ID	=			'{@MEM.SYSTEM_ID}'
		AND		A.FGLOAD	&lt;&gt;	'1'
	</og:text>
</og:tableUpdate>

<!-- ラベルをアップデートします -->
<!-- コードラベルのためにlikeをする必要があるため、EXISTSを利用します -->
<og:tableUpdate
	command		= "{@command}"
	queryType	= "JDBCTableUpdate">
	<og:text>
		UPDATE	GEA08 A
		SET		FGLOAD		=	'1'
		WHERE	EXISTS ( SELECT 'x' FROM GF79 B
						 WHERE ( B.NAME		= A.CLM OR B.NAME LIKE (A.CLM||'.%') )
						 AND B.SOURCE		= [SOURCE]
						 AND B.SYSTEM_ID	= '{@MEM.SYSTEM_ID}' )
		AND		A.FGJ		=			'1'
		AND		A.SYSTEM_ID	=			'{@MEM.SYSTEM_ID}'
		AND		A.FGLOAD	&lt;&gt;	'1'
	</og:text>
</og:tableUpdate>

<og:forward page="result.jsp" keys="command" vals="RENEW" />
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
