/**************************************************************************/
/* GF79 ( リソース抜出テーブル )                                          */
/*                                                                        */
/* Created : 2009/11/04 19:23:40                                          */
/**************************************************************************/
CREATE TABLE GF79 (
   SYSTEM_ID VARCHAR2(10)                 NOT NULL      /* 10  システムID   */
 , SOURCE    VARCHAR2(256)                              /* 20  ソース       */
 , FILENAME  VARCHAR2(30)                               /* 30  ファイル名   */
 , FILEPATH  VARCHAR2(256)                              /* 40  ファイルパス */
 , MODIFIED  VARCHAR2(14)                               /* 50  最終更新日   */
 , TAGNAME   VARCHAR2(30)                               /* 60  タグ名称     */
 , KBRSC     VARCHAR2(1)                                /* 70  リソース区分 */
 , NAME      VARCHAR2(200)                              /* 80  名称         */
 , UNIQ      NUMBER(9)        DEFAULT 0   NOT NULL      /* 90  ユニークキー */
 , FGJ       VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 100 状態フラグ   */
 , DYSET     VARCHAR2(14)                               /* 110 登録日時     */
 , DYUPD     VARCHAR2(14)                               /* 120 更新日時     */
 , USRSET    VARCHAR2(10)                               /* 130 作成社員     */
 , USRUPD    VARCHAR2(10)                               /* 140 更新者       */
 , PRGUPD    VARCHAR2(10)                               /* 150 更新PRG      */
 , FGOMIT    VARCHAR2(1)      DEFAULT '0' NOT NULL      /* 160 除外フラグ   */
)
TABLESPACE GETBL01
STORAGE( INITIAL 2048K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF79S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF79T01 
BEFORE INSERT ON GF79
FOR EACH ROW 
BEGIN 
SELECT GF79S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

