/**************************************************************************/
/* GF69 ( 不具合対策管理テーブル )                                        */
/*                                                                        */
/* Created : 2009/11/04 19:23:40                                          */
/**************************************************************************/
CREATE TABLE GF69 (
   PRJCODE     VARCHAR2(30)                  NOT NULL      /* 10  PRJコード    */
 , PHASE       VARCHAR2(1)                   NOT NULL      /* 20  実施フェーズ */
 , SEQNO       NUMBER(7)         DEFAULT 0   NOT NULL      /* 30  表示順       */
 , DYACC       VARCHAR2(8)                                 /* 40  発生日       */
 , PRG_NAME    VARCHAR2(120)                               /* 50  処理名称     */
 , PGID        VARCHAR2(30)                                /* 60  PG-ID        */
 , SINSEI      VARCHAR2(30)                                /* 70  申請者       */
 , TRBL_CONT   VARCHAR2(4000)                              /* 80  トラブル内容 */
 , ZANTEI      VARCHAR2(4000)                              /* 90  暫定対策     */
 , CDIMP       VARCHAR2(1)                                 /* 100 重要度       */
 , CDCONT      VARCHAR2(1)                                 /* 110 要因         */
 , CASUS       VARCHAR2(4000)                              /* 120 原因         */
 , BIKO        VARCHAR2(2000)                              /* 130 備考         */
 , RESOURCE_ID NUMBER(9)                                   /* 140 リソースID   */
 , ACT_CONT    VARCHAR2(4000)                              /* 150 対策内容     */
 , DYYOTE      VARCHAR2(8)                                 /* 160 予定         */
 , DYKAN       VARCHAR2(8)                                 /* 170 完成日       */
 , UNIQ        NUMBER(9)         DEFAULT 0   NOT NULL      /* 180 ユニークキー */
 , FGJ         VARCHAR2(1)       DEFAULT '1' NOT NULL      /* 190 状態フラグ   */
 , DYSET       VARCHAR2(14)                                /* 200 登録日時     */
 , DYUPD       VARCHAR2(14)                                /* 210 更新日時     */
 , USRSET      VARCHAR2(10)                                /* 220 作成社員     */
 , USRUPD      VARCHAR2(10)                                /* 230 更新者       */
 , PRGUPD      VARCHAR2(10)                                /* 240 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF69S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF69T01 
BEFORE INSERT ON GF69
FOR EACH ROW 
BEGIN 
SELECT GF69S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

