/**************************************************************************/
/* GF66 ( タスクリソース定義 )                                            */
/*                                                                        */
/* Created : 2009/11/04 19:23:40                                          */
/**************************************************************************/
CREATE TABLE GF66 (
   PRJCODE     VARCHAR2(30)                              /* 10  PRJコード    */
 , TASK_ID     NUMBER(5)                                 /* 20  タスクID     */
 , RESOURCE_ID NUMBER(9)                                 /* 30  リソースID   */
 , SEQ         NUMBER(5)       DEFAULT 0   NOT NULL      /* 40  順           */
 , LOAD        NUMBER(5)                                 /* 50  負荷         */
 , UNIQ        NUMBER(9)       DEFAULT 0   NOT NULL      /* 60  ユニークキー */
 , FGJ         VARCHAR2(1)     DEFAULT '1' NOT NULL      /* 70  状態フラグ   */
 , DYSET       VARCHAR2(14)                              /* 80  登録日時     */
 , DYUPD       VARCHAR2(14)                              /* 90  更新日時     */
 , USRSET      VARCHAR2(10)                              /* 100 作成社員     */
 , USRUPD      VARCHAR2(10)                              /* 110 更新者       */
 , PRGUPD      VARCHAR2(10)                              /* 120 更新PRG      */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF66S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF66T01 
BEFORE INSERT ON GF66
FOR EACH ROW 
BEGIN 
SELECT GF66S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

