/**************************************************************************/
/* GF63 ( リソースマスタ定義 )                                            */
/*                                                                        */
/* Created : 2009/11/04 19:23:39                                          */
/**************************************************************************/
CREATE TABLE GF63 (
   RESOURCE_ID NUMBER(9)                                  /* 10  リソースID     */
 , CDBUN       VARCHAR2(3)                                /* 20  分類コード     */
 , CDRSC       VARCHAR2(20)                               /* 30  リソースコード */
 , NAME        VARCHAR2(200)                              /* 40  名称           */
 , FUNCTION    VARCHAR2(2)                                /* 50  役割           */
 , LOAD        NUMBER(5)                                  /* 60  負荷           */
 , CONTACTS    VARCHAR2(100)                              /* 70  連絡           */
 , PHONE       VARCHAR2(15)                               /* 80  電話           */
 , UNIQ        NUMBER(9)        DEFAULT 0   NOT NULL      /* 90  ユニークキー   */
 , FGJ         VARCHAR2(1)      DEFAULT '1' NOT NULL      /* 100 状態フラグ     */
 , DYSET       VARCHAR2(14)                               /* 110 登録日時       */
 , DYUPD       VARCHAR2(14)                               /* 120 更新日時       */
 , USRSET      VARCHAR2(10)                               /* 130 作成社員       */
 , USRUPD      VARCHAR2(10)                               /* 140 更新者         */
 , PRGUPD      VARCHAR2(10)                               /* 150 更新PRG        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 64K NEXT 16K PCTINCREASE 0 );

CREATE SEQUENCE GF63S01 
INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;

CREATE OR REPLACE TRIGGER GF63T01 
BEFORE INSERT ON GF63
FOR EACH ROW 
BEGIN 
SELECT GF63S01.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
END; 
/

