/**
 * Ajax動的カラム変更用の共通JavaScript
 * 
 * カラムにeventColumnをセットした時に親側にID指定でChangeイベントとして登録されます。
 * JSP側へのリクエスト変数としては次のものが渡されます。
 * (呼ばれたJSPで{@EC_SQL}のようにして利用可能)
 * EC_SQL		paramで指定したSQLの{@xxx}をカラムのvalue値で置き換えたSQL文
 * EC_CID		引数の_idの値（子カラムID)
 * EC_CNAME		引数の_nameの値（子のカラム名）
 * EC_EDITOR	引数の_editor（子カラムのeditor）
 * EC_CVALUE	引数_id要素のvalue値（子の値）
 * EC_NOVALUE	引数_id要素の最上部Option値が空ならtrue。その他false
 * EC_MUST		引数_id要素にmust,mustAnyのクラスがセットされている場合に該当クラス文字列を送ります
 * これらは常に渡されますが、他にもparamのSQL文内の{@xxx}のvalue値を
 * xxxの名前で渡しています。（親の値をjspで利用可能）
 *
 * {@xxx}はinputやselectの実際の値を取得するため、カラムが存在しない値
 * (USER.xxx等）はparamにセットできません。
 * これらを利用する場合は一度hiddenで受ける等してから利用する必要があります。
 *
 * @param _id		変更対象のID(子のID)
 * @param _name		子のカラム名
 * @param _sql		SQL文({@xxx}はカラムのvalue値で置き換えられる)
 * @param _editor	子のeditor(標準のmakeColumn.jspで利用)
 * @param _url		呼び出すJSPのURL
**/
function makeColumn(_id,_name,_sql,_editor,_url){
	
	//__iが付いた場合と付かない場合でのvalue値取得処理吸収用
	var _suffix = "";
	if(_id != _name){
		_suffix = _id.substring(_name.length,_id.length);
	}
	
	// クッキー処理の場合　前後の""対策。
	// _sql=_sql.substring(1,_sql.length-1);

	// SQL文をパースして{@xxx}をxxxのvalue値に変更する。一覧での利用では同一行のカラムになる。
	//（リクエスト変数はテキストボックスで一度受ける必要がある）
	// 又、パースして得られたvalue値をJSPのリクエスト変数としてURLの後ろに付ける
	var _pos1 = 0;
	var _pos2 = 0;
	var _vals = "?";
	var _repClm;
	var _rep;
	var _clm;
	while( (_pos1 = _sql.indexOf("{@",_pos2)) != -1){
		_pos2 = _sql.indexOf("}",_pos1);
		_clm = _sql.substring(_pos1+2,_pos2);
		_repClm = "{@"+_clm+"}";
		_rep = _suffix == null ? $('#'+_clm).val() : $('#'+_clm+_suffix).val();
		_sql = _sql.replace(_repClm,_rep);
		_vals += _clm + "=" +  encodeURIComponent(_rep) +"&"; 
		_pos2 = _pos1; // 4.3.6.2 (2009/04/15)
	}

	// 子がSelectタグの場合、最上部に空のoptionが存在すればEC_NOVALUEをtrueで送る
	var _noVal = function(){
		_firstOption = $('#'+_id).children('option').get(0);
		if( _firstOption == null || _firstOption.value!='' ){ return false; }
		return true;
	}

	// 4.3.6.5 (2009/05/08) must,mustAnyを引数でJSPに送る。
	var _mustOrMustAny = function(){
		var _haveClasses = $('#'+_id).attr("class");
		if( _haveClasses.indexOf("must") >= 0 ){
			 if( _haveClasses.indexOf("mustAny") >= 0 ){
			 	return "mustAny";
			 }
			 else{
			 	return "must";
			 }
			 return "";
		}
	}

	// JSPを呼び出して処理する
	$.ajax({
	url: _url + _vals,
	data: {
		"EC_SQL": _sql,
		"EC_CID": _id,
		"EC_CNAME": _name,
		"EC_EDITOR": _editor,
		"EC_CVALUE": $('#'+_id).val(),
		"EC_NOVALUE": _noVal(),
		"EC_MUST": _mustOrMustAny()
	},
	type: 'POST',
	dataType: 'html',
	error: function(r,s,e){alert('EventColumnError:'+r+':'+s+':'+e+':'+_name);},
	success: function(data,status){
		// 帰ってきたもので入替える
		_tag = $(data);
		replaceColumn(_id,_tag);
		// alert($('#'+_id).closest('td').html());
	}
	});
}

/**
 * _idの内容を_tagの内容で置き換える。
 * 帰ってきた
 * なお、_idが持っていたイベントは全て引き継ぐ。
**/
function replaceColumn(_id,_tag){
	var _sid = '#'+_id;
	var _events = jQuery.data( $(_sid).clone(true).get(0), "events" );
	$(_sid).replaceWith(_tag);
	// $(_sid).attr('name',_id); // name入れ替え
	for ( var type in _events ) {
		for ( var handler in _events[ type ] ) {
			jQuery.event.add( $(_sid).get(0), type, _events[ type ][ handler ], _events[ type ][ handler ].data );
		}
	}
}