<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" />
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GE:エンジン"
	pgid	= "MAIL05"
	title	= "デーモン起動(Mail)"
	date	= "2009/04/01"
	author	= "S.Li"
	text	= ""
	version	= "001"
/>

<og:query command="NEW" debug="{@debug}" maxRowCount="{@maxRowCount}">
	<jsp:text>
	SELECT   GE31.SYSTEM_ID 
			,'SET'  AS CMD_SET
			,'REMOVE' AS CMD_REMOVE
			,'5000' AS PERIOD
			,GE12.CONTXT_PATH
	FROM GE31  LEFT OUTER JOIN GE12
			ON  GE12.PARAM_ID = ('CONTEXT_INITIAL_CALL_URL_MAIL_DAEMON_' || GE31.SYSTEM_ID )
				AND GE12.FGJ = '1'
	WHERE GE31.FGJ = '1'
	GROUP BY GE31.SYSTEM_ID,GE12.CONTXT_PATH
	</jsp:text>
</og:query>

<!-- ViewLinkTag は、指定のカラムにリンクを張ります。keysと、valsに、URLエンコードする値を設定します。 -->
<!-- 子要素の LinkTag は、単独でも使用できます。[カラム名] で、検索結果の各行毎の値を使用できます。 -->
<og:viewLink command="NEW">
	<og:link column="CMD_SET" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,CMD,PERIOD"
		vals="NEW,[SYSTEM_ID],SET,[PERIOD]" lbl="ENTRY" />
	<og:link column="CMD_REMOVE" href="result.jsp" target="RESULT"
		keys="command,SYSTEM_ID,CMD"
		vals="NEW,[SYSTEM_ID],REMOVE" lbl="DELETE" />
</og:viewLink>

<og:view
	viewFormType = "HTMLCustomTable"
	command    = "NEW"
	checked    = "{@checked}"
	startNo    = "{@startNo}"
	pageSize   = "{@pageSize}"
	writable   = "false"
	useScrollBar = "false"
	rowspan    = "1" >
	<og:thead rowspan="1" >
		<tr>
			<td>System ID</td><td colspan="2">Deamon</td><td>AutoRun</td>
		</tr>
	</og:thead>

	<og:tbody rowspan="1">
		<tr>
			<td>[SYSTEM_ID]</td><td>[CMD_SET]</td><td>[CMD_REMOVE]</td><td>[CONTXT_PATH]</td>
		</tr>
	</og:tbody>
</og:view>
<br />
<og:link href="result.jsp" target="RESULT" keys="CMD" vals="VIEW" >
[<og:message lbl="QUERY" />]
</og:link>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
