/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.view;

import java.util.Calendar;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.plugin.view.AbstractViewForm;

public class ViewForm_HTMLCalendar
extends AbstractViewForm {
    private static final String VERSION = "4.0.0 (2005/08/31)";
    private static final String[] WEEK_ja = new String[]{"\u65e5", "\u6708", "\u706b", "\u6c34", "\u6728", "\u91d1", "\u571f", "\u65e5", "\u6708"};
    private static final String[] WEEK_en = new String[]{"SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN", "MON"};
    private static final String[] WEEK_MK = new String[]{"SUN", "", "", "", "", "", "SAT", "SUN", ""};
    private String[] week;
    private String[] viewKeys;
    private String ymKey;
    private String dayKey;
    private String valKey;
    private boolean valueBrFlag;
    private int firstWeek;
    private int columnSize;

    public String create(int n, int n2) {
        boolean bl;
        if (this.getRowCount() == 0) {
            return "";
        }
        this.paramInit();
        int n3 = this.getLastNo(n, n2);
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<table><tr>").append(HybsSystem.CR);
        boolean bl2 = bl = n3 - n == 1;
        if (!bl && this.isUseCheckControl() && "checkbox".equals(this.getSelectedType())) {
            stringBuilder.append("<tr><td>").append(this.getAllCheckControl()).append("</td></tr>");
        }
        for (int i = n; i < n3; ++i) {
            stringBuilder.append("<td valign=\"top\">");
            if (this.isWritable(i)) {
                if (bl) {
                    stringBuilder.append(XHTMLTag.hidden((String)"h_rowSel", (String)String.valueOf(i)));
                    stringBuilder.append(HybsSystem.CR);
                } else {
                    stringBuilder.append("<input type=\"").append(this.getSelectedType()).append("\" ");
                    stringBuilder.append("name=\"").append("h_rowSel").append("\" ");
                    if (this.isChecked(i)) {
                        stringBuilder.append(" checked=\"checked\"");
                    }
                    stringBuilder.append("value=\"").append(i).append("\" />");
                }
            }
            for (int j = 0; j < this.viewKeys.length; ++j) {
                if ("_".equals(this.viewKeys[j])) continue;
                int n4 = this.getColumnNo(this.viewKeys[j]);
                stringBuilder.append("<span id=\"label\">");
                stringBuilder.append(this.getColumnLabel(n4));
                stringBuilder.append(":</span>");
                stringBuilder.append(this.getValueLabel(i, n4));
                stringBuilder.append("&nbsp;");
            }
            stringBuilder.append(HybsSystem.BR);
            stringBuilder.append(this.makeCalendarData(i));
            stringBuilder.append("</td>");
            if ((i + 1) % this.columnSize != 0) continue;
            stringBuilder.append("</tr><tr>").append(HybsSystem.CR);
        }
        stringBuilder.append("</tr></table>").append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    private String makeCalendarData(int n) {
        String string = this.getValue(n, this.getColumnNo(this.ymKey));
        Calendar calendar = this.getCalendar(string);
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append("<table id=\"viewCalendar\" border=\"0\" cellpadding=\"1\" cellspacing=\"2\">").append(HybsSystem.CR);
        stringBuilder.append("  <tr><td class=\"titleStyle\" colspan=\"7\">").append(HybsSystem.CR);
        stringBuilder.append(this.getValueLabel(n, this.getColumnNo(this.ymKey))).append(HybsSystem.CR);
        stringBuilder.append("  </td></tr>").append(HybsSystem.CR);
        int n2 = calendar.getActualMaximum(5);
        calendar.setFirstDayOfWeek(1 + this.firstWeek);
        int n3 = (calendar.get(7) + (7 - calendar.getFirstDayOfWeek())) % 7;
        stringBuilder.append("  <tr>").append(HybsSystem.CR);
        for (int i = 0; i < 7; ++i) {
            stringBuilder.append("    <td width=\"14%\" class=\"dayHead");
            stringBuilder.append(WEEK_MK[i + this.firstWeek]).append("\">");
            stringBuilder.append(this.week[i + this.firstWeek]).append("</td>");
            stringBuilder.append(HybsSystem.CR);
        }
        stringBuilder.append("  </tr>").append(HybsSystem.CR);
        if (n3 != 0) {
            stringBuilder.append("    <td colspan=\"").append(n3).append("\">&nbsp;</td>");
        }
        String string2 = this.valueBrFlag ? "<br />" : "";
        for (int i = 1; i <= n2; ++i) {
            int n4 = this.getColumnNo(this.dayKey + i);
            String string3 = this.getValueLabel(n, n4, i);
            String string4 = "";
            if (this.valKey != null) {
                int n5 = this.getColumnNo(this.valKey + i);
                string4 = string2 + this.getValueLabel(n, n5);
            }
            if ("1".equals(this.getValue(n, n4))) {
                stringBuilder.append("    <td class=\"holyday\">");
                stringBuilder.append(string3);
                stringBuilder.append(string4);
                stringBuilder.append("</td>");
            } else {
                stringBuilder.append("    <td class=\"day");
                stringBuilder.append(WEEK_MK[n3 + this.firstWeek]);
                stringBuilder.append("\">");
                stringBuilder.append(string3);
                stringBuilder.append(string4);
                stringBuilder.append("</td>");
            }
            stringBuilder.append(HybsSystem.CR);
            if (n3 == 6) {
                stringBuilder.append("  </tr>\n  <tr>").append(HybsSystem.CR);
                n3 = 0;
                continue;
            }
            ++n3;
        }
        if (7 - n3 != 0) {
            stringBuilder.append("    <td colspan=\"").append(7 - n3).append("\">&nbsp;</td>");
        }
        stringBuilder.append(HybsSystem.CR);
        stringBuilder.append("</tr>").append(HybsSystem.CR);
        stringBuilder.append("</table>").append(HybsSystem.CR);
        return stringBuilder.toString();
    }

    private void paramInit() {
        String string = this.getParam("h_viewKeys", "CDJGS");
        this.ymKey = this.getParam("h_ymKey", "YYYYMM");
        this.dayKey = this.getParam("h_dayKey", "DY");
        this.valKey = this.getParam("h_valueKey", null);
        String string2 = this.getParam("h_valueBRFlagKey", "true");
        String string3 = this.getParam("h_firstWeek", "0");
        String string4 = this.getParam("h_headerLocale", "en");
        String string5 = this.getParam("h_columnSize", "3");
        this.viewKeys = StringUtil.csv2Array((String)string);
        this.firstWeek = Integer.parseInt(string3);
        this.valueBrFlag = Boolean.valueOf(string2);
        this.columnSize = Integer.parseInt(string5);
        this.week = "ja".equals(string4) ? WEEK_ja : WEEK_en;
    }

    private String getValueLabel(int n, int n2, int n3) {
        if (this.isColumnWritable(n2) && this.isWritable(n)) {
            String string = this.getValue(n, n2);
            return n3 + this.getEditorValue(n, n2, string);
        }
        return String.valueOf(n3);
    }

    private Calendar getCalendar(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string != null && string.length() == 6) {
            int n = Integer.parseInt(string.substring(0, 4));
            int n2 = Integer.parseInt(string.substring(4, 6)) - 1;
            int n3 = 1;
            calendar.set(n, n2, n3, 0, 0, 0);
        } else {
            calendar.set(5, 1);
        }
        return calendar;
    }

    public boolean canUseFormat() {
        return false;
    }
}

