/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.util.ModifyFileFilter;

public final class HybsFileFilter
implements FileFilter {
    private final List<FileFilter> list = new ArrayList<FileFilter>();

    @Override
    public boolean accept(File file) {
        if (file != null && file.isFile()) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                FileFilter fileFilter = this.list.get(i);
                if (fileFilter.accept(file)) continue;
                return false;
            }
        }
        return true;
    }

    public void addFileFilter(FileFilter fileFilter) {
        if (fileFilter != null) {
            this.list.add(fileFilter);
        }
    }

    public void startsWith(String string) {
        if (string != null) {
            this.list.add(new StartsWithFilter(string));
        }
    }

    public void endsWith(String string) {
        if (string != null) {
            this.list.add(new EndsWithFilter(string));
        }
    }

    public void instr(String string) {
        if (string != null) {
            this.list.add(new InstrFilter(string));
        }
    }

    public void fileEquals(String string) {
        if (string != null) {
            this.list.add(new EqualsFilter(string));
        }
    }

    public void matches(String string) {
        if (string != null) {
            this.list.add(new MatchesFilter(string));
        }
    }

    public void unMatches(String string) {
        if (string != null) {
            this.list.add(new UnMatchesFilter(string));
        }
    }

    public void lastModified(String string) {
        if (string != null) {
            this.list.add(new ModifyFileFilter(string));
        }
    }

    public void isLarger(int n) {
        if (n >= 0) {
            this.list.add(new IsLargerFilter(n));
        }
    }

    public void isSmaller(int n) {
        if (n >= 0) {
            this.list.add(new IsSmallerFilter(n));
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.list.size();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("no[").append(i).append("]=");
            stringBuilder.append(this.list.get(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    private static class IsSmallerFilter
    implements FileFilter {
        private final long size;

        IsSmallerFilter(int n) {
            this.size = n;
        }

        @Override
        public boolean accept(File file) {
            return file.length() < this.size;
        }
    }

    private static class IsLargerFilter
    implements FileFilter {
        private final long size;

        IsLargerFilter(int n) {
            this.size = n;
        }

        @Override
        public boolean accept(File file) {
            return file.length() >= this.size;
        }
    }

    private static class UnMatchesFilter
    implements FileFilter {
        private final Pattern pattern;

        UnMatchesFilter(String string) {
            this.pattern = Pattern.compile(string, 2);
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            return !matcher.find();
        }
    }

    private static class MatchesFilter
    implements FileFilter {
        private final Pattern pattern;

        MatchesFilter(String string) {
            this.pattern = Pattern.compile(string, 2);
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.pattern.matcher(file.getName());
            return matcher.find();
        }
    }

    private static class EqualsFilter
    implements FileFilter {
        private final String eqstr;

        EqualsFilter(String string) {
            this.eqstr = string;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().equalsIgnoreCase(this.eqstr);
        }
    }

    private static class InstrFilter
    implements FileFilter {
        private final String instr;

        InstrFilter(String string) {
            this.instr = string;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().indexOf(this.instr) >= 0;
        }
    }

    private static class EndsWithFilter
    implements FileFilter {
        private final String sfix;

        EndsWithFilter(String string) {
            this.sfix = string;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(this.sfix);
        }
    }

    private static class StartsWithFilter
    implements FileFilter {
        private final String pfix;

        StartsWithFilter(String string) {
            this.pfix = string;
        }

        @Override
        public boolean accept(File file) {
            return file.getName().startsWith(this.pfix);
        }
    }
}

