/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.db;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.validation.SchemaFactory;
import org.opengion.fukurou.db.EDbid;
import org.opengion.fukurou.util.LogWriter;
import org.opengion.fukurou.xml.jaxb.dbid.DbConfig;
import org.opengion.fukurou.xml.jaxb.dbid.DbDriver;
import org.opengion.fukurou.xml.jaxb.dbid.Dbid;
import org.xml.sax.SAXException;

public class DatabaseConfig {
    private static final String DEFAULT_DRIVER = "oracle.jdbc.OracleDriver";
    private final String XmlFilename;
    private static final String SCHEMA_FILENAME = "DBConfig.xsd";
    private final Map<String, EDbid> dbidMap = new HashMap<String, EDbid>();
    private List<String> driverList = new ArrayList<String>();
    private static final String CR = System.getProperty("line.separator");

    public DatabaseConfig() {
        this("../DBConfig.xml");
    }

    public DatabaseConfig(String string) {
        this.XmlFilename = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EDbid getDbid(String string) {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            if (this.dbidMap.isEmpty()) {
                this.init();
            }
            return this.dbidMap.get(string.toUpperCase(Locale.JAPAN));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Map<String, EDbid> map = this.dbidMap;
        synchronized (map) {
            this.dbidMap.clear();
        }
    }

    private void init() {
        this.loadXML(this.XmlFilename, SCHEMA_FILENAME);
        this.loadDriver();
    }

    private void loadXML(String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        DbConfig dbConfig = null;
        try {
            object5 = JAXBContext.newInstance((String)"org.opengion.fukurou.xml.jaxb.dbid");
            object4 = object5.createUnmarshaller();
            Class<?> clazz = Class.forName("org.opengion.fukurou.xml.jaxb.dbid.ObjectFactory");
            object3 = clazz.getResource(string2);
            object2 = clazz.getClassLoader();
            object = ((ClassLoader)object2).getResource(string);
            if (object != null) {
                object4.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema((URL)object3));
                dbConfig = (DbConfig)object4.unmarshal((URL)object);
            }
        }
        catch (JAXBException jAXBException) {
            String string3 = (Object)((Object)jAXBException) + ":" + string + "\u3082\u3057\u304f\u306f" + string2 + "\u304c\u5b58\u5728\u3057\u3066\u3044\u306a\u3044\u304b\u3001XML\u304c\u30b9\u30ad\u30fc\u30de\u306b\u6cbf\u3063\u3066\u3044\u307e\u305b\u3093\u3002" + CR;
            throw new RuntimeException(string3, jAXBException);
        }
        catch (SAXException sAXException) {
            LogWriter.log(sAXException);
            throw new RuntimeException(sAXException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogWriter.log(classNotFoundException);
            throw new RuntimeException(classNotFoundException);
        }
        if (dbConfig == null) {
            object5 = "dbconfig\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002DBConfig.xml = " + string + CR;
            throw new RuntimeException((String)object5);
        }
        object5 = dbConfig.getDbDriver();
        if (object5 == null) {
            this.driverList.add(DEFAULT_DRIVER);
        } else {
            this.driverList = ((DbDriver)object5).getClazz();
        }
        object4 = dbConfig.getDbid();
        for (int i = 0; i < object4.size(); ++i) {
            object3 = (Dbid)object4.get(i);
            object2 = ((Dbid)object3).getDbidKey().toUpperCase(Locale.JAPAN);
            object = new EDbid();
            ((EDbid)object).setDbidKey((String)object2);
            if ("".equals(((Dbid)object3).getUrl())) {
                ((EDbid)object).setUrl(System.getenv("REALM_URL"));
            } else {
                ((EDbid)object).setUrl(((Dbid)object3).getUrl());
            }
            if ("".equals(((Dbid)object3).getUser())) {
                ((EDbid)object).setUser(System.getenv("REALM_NAME"));
            } else {
                ((EDbid)object).setUser(((Dbid)object3).getUser());
            }
            if ("".equals(((Dbid)object3).getPassword())) {
                ((EDbid)object).setPassword(System.getenv("REALM_PASSWORD"));
            } else {
                ((EDbid)object).setPassword(((Dbid)object3).getPassword());
            }
            ((EDbid)object).setMaxcount(((Dbid)object3).getMaxcount());
            ((EDbid)object).setMincount(((Dbid)object3).getMincount());
            ((EDbid)object).setPooltime(((Dbid)object3).getPooltime());
            ((EDbid)object).setReadonly(((Dbid)object3).isReadonly());
            ((EDbid)object).setApplicationInfo(((Dbid)object3).isApplicationInfo());
            this.dbidMap.put((String)object2, (EDbid)object);
        }
    }

    private void loadDriver() {
        for (int i = 0; i < this.driverList.size(); ++i) {
            try {
                Class.forName(this.driverList.get(i));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string = "\u30c9\u30e9\u30a4\u30d0\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + this.driverList.get(i) + "]";
                LogWriter.log(string);
                LogWriter.log(classNotFoundException);
            }
        }
    }
}

