/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.mail;

import java.util.Map;
import java.util.TreeMap;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.mail.AbstractMailManager;
import org.opengion.hayabusa.resource.ResourceManager;

public class MailManager_DIRECT
extends AbstractMailManager {
    private static final String[] names = new String[]{"DST_ID", "GROUP_ID", "GROUP_NAME", "DST_NAME", "DST_ADDR", "DST_KBN", "FGJ_MAIL"};
    private static final int IDX_DST_ID = 0;
    private static final int IDX_FGJ_MAIL = 6;
    private DBColumn[] dbColumn = null;
    private ResourceManager resource = null;

    public void create(Map<String, String> map, DBTableModel dBTableModel) {
        this.setInitParams(map);
        this.setAttachFiles(map.get("ATTACH1"), map.get("ATTACH2"), map.get("ATTACH3"), map.get("ATTACH4"), map.get("ATTACH5"));
        Map<String, String[]> map2 = this.makeMailDstMap(dBTableModel);
        this.setMailDstMap(map2);
    }

    public DBTableModel makeDstTable() {
        Map<String, String[]> map = this.getMailDstMap();
        int n = names.length;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(n);
        this.setTableDBColumn(dBTableModel, names);
        for (String string : map.keySet()) {
            String[] stringArray = map.get(string);
            dBTableModel.addColumnValues(stringArray);
        }
        return dBTableModel;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resource = resourceManager;
    }

    protected void setTableDBColumn(DBTableModel dBTableModel, String[] stringArray) {
        this.dbColumn = new DBColumn[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            DBColumn dBColumn = this.resource.makeDBColumn(stringArray[i]);
            dBTableModel.setDBColumn(i, dBColumn);
            this.dbColumn[i] = dBColumn;
        }
    }

    private Map<String, String[]> makeMailDstMap(DBTableModel dBTableModel) {
        TreeMap<String, String[]> treeMap = new TreeMap<String, String[]>();
        int n = dBTableModel.getRowCount();
        int n2 = names.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray = new String[n2];
            if (!"0".equals(dBTableModel.getValue(i, 6))) continue;
            for (int j = 0; j < n2; ++j) {
                stringArray[j] = (String)dBTableModel.getValue(i, j);
            }
            treeMap.put(stringArray[0], stringArray);
        }
        return treeMap;
    }
}

