/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FileTreeModel {
    TreeModel model = null;
    String dir = null;

    public FileTreeModel() {
        this.initialise(null);
    }

    public FileTreeModel(String string) {
        this.initialise(string);
    }

    public void setDirectory(String string) {
        this.initialise(string);
    }

    private void initialise(String string) {
        this.dir = string;
        if (this.dir == null) {
            this.dir = ".";
        }
        DefaultMutableTreeNode defaultMutableTreeNode = this.makeTree(new File(this.dir));
        this.model = new DefaultTreeModel(defaultMutableTreeNode);
    }

    public TreeModel getTreeModel() {
        return this.model;
    }

    private DefaultMutableTreeNode makeTree(File file) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(file.getName());
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                defaultMutableTreeNode.add(this.makeTree(new File(file, stringArray[i])));
            }
        }
        return defaultMutableTreeNode;
    }

    public void printTree(TreeNode treeNode, TreeModel treeModel, int n) {
        int n2 = treeModel.getChildCount(treeNode);
        TreeNode[] treeNodeArray = new TreeNode[n2];
        for (int i = 0; i < n2; ++i) {
            treeNodeArray[i] = (TreeNode)treeModel.getChild(treeNode, i);
            if (treeNodeArray[i].isLeaf()) {
                System.out.println(n + ":" + treeNodeArray[i].toString());
                continue;
            }
            System.out.println(n + ":" + treeNodeArray[i].toString());
            this.printTree(treeNodeArray[i], treeModel, n + 1);
        }
    }

    public static void main(String[] stringArray) {
        FileTreeModel fileTreeModel = new FileTreeModel(stringArray[0]);
        TreeModel treeModel = fileTreeModel.getTreeModel();
        TreeNode treeNode = (TreeNode)treeModel.getRoot();
        fileTreeModel.printTree(treeNode, treeModel, 0);
    }
}

