package models.services
import org.squeryl._
import org.squeryl.PrimitiveTypeMode._
import models._

case class UserManager() {
  def userList(request: play.api.mvc.Request[play.api.mvc.AnyContent]): String = {
      var userList:String = ""
      inTransaction {
        val users = PartsListDb.users.where(u => u.name like request.getQueryString("q").get + "%")
        for(user <- users) {
          userList = userList.concat(user.name)
          userList = userList.concat("\n")
         }
       }
      return userList
  }
  
  def insert(user: User) = {
    PartsListDb.users.insert(User(user.name, user.email))
  }
  
  def update(user: User, id: Long) = {
    val updUser = UserManager().getById(id)
    updUser.name = user.name
    updUser.email = user.email
    PartsListDb.users.update(updUser)
  }
  
  def list(key: String): org.squeryl.Query[User] = {
    PartsListDb.users.where(u => u.name like key + "%")
  }
  
  def getByName(name: String):User = {
    PartsListDb.users.where(u => u.name === name).head
  }
  
  def getById(id: Long) = {
    PartsListDb.users.where(u => u.id === id).head
  }

}