/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher.graphviz;

import com.google.inject.grapher.graphviz.NodeShape;
import com.google.inject.grapher.graphviz.NodeStyle;
import com.google.inject.internal.util.;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphvizNode {
    private final String nodeId;
    private NodeStyle style = NodeStyle.SOLID;
    private NodeShape shape = NodeShape.BOX;
    private String title = "";
    private Map<Integer, String> subtitles = .Maps.newTreeMap();
    private String headerTextColor = "#000000";
    private String headerBackgroundColor = "#ffffff";
    private Map<String, String> fields = .Maps.newLinkedHashMap();

    public GraphvizNode(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public NodeShape getShape() {
        return this.shape;
    }

    public void setShape(NodeShape shape) {
        this.shape = shape;
    }

    public NodeStyle getStyle() {
        return this.style;
    }

    public void setStyle(NodeStyle style) {
        this.style = style;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<String> getSubtitles() {
        return .ImmutableList.copyOf(this.subtitles.values());
    }

    public void addSubtitle(int position, String subtitle) {
        this.subtitles.put(position, subtitle);
    }

    public String getHeaderTextColor() {
        return this.headerTextColor;
    }

    public void setHeaderTextColor(String headerTextColor) {
        this.headerTextColor = headerTextColor;
    }

    public String getHeaderBackgroundColor() {
        return this.headerBackgroundColor;
    }

    public void setHeaderBackgroundColor(String headerBackgroundColor) {
        this.headerBackgroundColor = headerBackgroundColor;
    }

    public void addField(String portId, String title) {
        this.fields.put(portId, title);
    }

    public Map<String, String> getFields() {
        return .ImmutableMap.copyOf(this.fields);
    }
}

