/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.grapher;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.grapher.BindingEdge;
import com.google.inject.grapher.DependencyEdge;
import com.google.inject.grapher.ImplementationNode;
import com.google.inject.grapher.InterfaceNode;
import com.google.inject.grapher.NodeAliasFactory;
import com.google.inject.grapher.NodeIdFactory;
import com.google.inject.internal.util.;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphingVisitor<K, N extends InterfaceNode<K>, M extends ImplementationNode<K>, B extends BindingEdge<K>, D extends DependencyEdge<K>>
implements BindingTargetVisitor<Object, Void> {
    private final NodeIdFactory<K> idFactory;
    private final InterfaceNode.Factory<K, N> interfaceNodeFactory;
    private final ImplementationNode.Factory<K, M> implementationNodeFactory;
    private final BindingEdge.Factory<K, B> bindingEdgeFactory;
    private final DependencyEdge.Factory<K, D> dependencyEdgeFactory;
    private final NodeAliasFactory<K> nodeAliasFactory;

    @Inject
    public GraphingVisitor(NodeIdFactory<K> idFactory, InterfaceNode.Factory<K, N> interfaceNodeFactory, ImplementationNode.Factory<K, M> implementationNodeFactory, BindingEdge.Factory<K, B> bindingEdgeFactory, DependencyEdge.Factory<K, D> dependencyEdgeFactory, NodeAliasFactory<K> nodeAliasFactory) {
        this.idFactory = idFactory;
        this.interfaceNodeFactory = interfaceNodeFactory;
        this.implementationNodeFactory = implementationNodeFactory;
        this.bindingEdgeFactory = bindingEdgeFactory;
        this.dependencyEdgeFactory = dependencyEdgeFactory;
        this.nodeAliasFactory = nodeAliasFactory;
    }

    protected final K getClassNodeId(Binding<?> binding) {
        return this.idFactory.getClassNodeId(binding.getKey());
    }

    protected final K getInstanceNodeId(Binding<?> binding) {
        return this.idFactory.getInstanceNodeId(binding.getKey());
    }

    protected N newInterfaceNode(Binding<?> binding) {
        N node = this.interfaceNodeFactory.newInterfaceNode(this.getClassNodeId(binding));
        node.setKey(binding.getKey());
        node.setSource(binding.getSource());
        return node;
    }

    protected M newClassImplementationNode(Binding<?> binding, InjectionPoint constructorInjectionPoint, Collection<InjectionPoint> memberInjectionPoints) {
        M node = this.implementationNodeFactory.newImplementationNode(this.getClassNodeId(binding));
        node.setClassKey(binding.getKey());
        node.addMember(constructorInjectionPoint.getMember());
        for (InjectionPoint injectionPoint : memberInjectionPoints) {
            node.addMember(injectionPoint.getMember());
        }
        return node;
    }

    protected M newInstanceImplementationNode(Binding<?> binding, Object instance) {
        M node = this.implementationNodeFactory.newImplementationNode(this.getInstanceNodeId(binding));
        node.setSource(binding.getSource());
        node.setInstance(instance);
        return node;
    }

    protected B newBindingEdge(K nodeId, K toId, BindingEdge.Type type) {
        B edge = this.bindingEdgeFactory.newBindingEdge(nodeId, toId);
        edge.setType(type);
        return edge;
    }

    protected Collection<D> newDependencyEdges(K nodeId, M node, Collection<Dependency<?>> dependencies) {
        ArrayList edges = .Lists.newArrayList();
        for (Dependency<?> dependency : dependencies) {
            InjectionPoint injectionPoint = dependency.getInjectionPoint();
            if (injectionPoint != null) {
                node.addMember(injectionPoint.getMember());
            }
            D edge = this.newDependencyEdge(nodeId, injectionPoint, dependency);
            edges.add(edge);
        }
        return edges;
    }

    protected D newDependencyEdge(K nodeId, @.Nullable InjectionPoint injectionPoint, Dependency<?> dependency) {
        K toId = this.idFactory.getClassNodeId(dependency.getKey());
        return this.dependencyEdgeFactory.newDependencyEdge(nodeId, injectionPoint, toId);
    }

    public Void visit(ConstructorBinding<?> binding) {
        M node = this.newClassImplementationNode((Binding<?>)binding, binding.getConstructor(), binding.getInjectableMembers());
        this.newDependencyEdges(this.getClassNodeId((Binding<?>)binding), node, binding.getDependencies());
        return null;
    }

    public Void visit(ConvertedConstantBinding<?> binding) {
        this.newInterfaceNode((Binding<?>)binding);
        this.newBindingEdge(this.getClassNodeId((Binding<?>)binding), this.idFactory.getClassNodeId(binding.getSourceKey()), BindingEdge.Type.CONVERTED_CONSTANT);
        return null;
    }

    public Void visit(ExposedBinding<?> binding) {
        return null;
    }

    public Void visit(InstanceBinding<?> binding) {
        this.newInterfaceNode((Binding<?>)binding);
        this.newBindingEdge(this.getClassNodeId((Binding<?>)binding), this.getInstanceNodeId((Binding<?>)binding), BindingEdge.Type.NORMAL);
        M node = this.newInstanceImplementationNode((Binding<?>)binding, binding.getInstance());
        this.newDependencyEdges(this.getInstanceNodeId((Binding<?>)binding), node, binding.getDependencies());
        return null;
    }

    public Void visit(LinkedKeyBinding<?> binding) {
        this.newInterfaceNode((Binding<?>)binding);
        this.newBindingEdge(this.getClassNodeId((Binding<?>)binding), this.idFactory.getClassNodeId(binding.getLinkedKey()), BindingEdge.Type.NORMAL);
        return null;
    }

    public Void visit(ProviderBinding<?> binding) {
        this.nodeAliasFactory.newAlias(this.getClassNodeId((Binding<?>)binding), this.idFactory.getClassNodeId(binding.getProvidedKey()));
        return null;
    }

    public Void visit(ProviderInstanceBinding<?> binding) {
        this.newInterfaceNode((Binding<?>)binding);
        this.newBindingEdge(this.getClassNodeId((Binding<?>)binding), this.getInstanceNodeId((Binding<?>)binding), BindingEdge.Type.PROVIDER);
        M node = this.newInstanceImplementationNode((Binding<?>)binding, binding.getProviderInstance());
        this.newDependencyEdges(this.getInstanceNodeId((Binding<?>)binding), node, binding.getDependencies());
        return null;
    }

    public Void visit(ProviderKeyBinding<?> binding) {
        this.newInterfaceNode((Binding<?>)binding);
        this.newBindingEdge(this.getClassNodeId((Binding<?>)binding), this.idFactory.getClassNodeId(binding.getProviderKey()), BindingEdge.Type.PROVIDER);
        return null;
    }

    public Void visit(UntargettedBinding<?> binding) {
        return null;
    }
}

