/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.internal.util.;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderWithDependencies;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.CheckedProviderMethod;
import com.google.inject.throwingproviders.CheckedProviderMethodsModule;
import com.google.inject.throwingproviders.ThrowingProvider;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThrowingProviderBinder {
    private final Binder binder;

    private ThrowingProviderBinder(Binder binder) {
        this.binder = binder;
    }

    public static ThrowingProviderBinder create(Binder binder) {
        return new ThrowingProviderBinder(binder.skipSources(new Class[]{ThrowingProviderBinder.class, SecondaryBinder.class}));
    }

    public static Module forModule(Module module) {
        return CheckedProviderMethodsModule.forModule(module);
    }

    public <P extends CheckedProvider> SecondaryBinder<P> bind(Class<P> interfaceType, Type valueType) {
        return new SecondaryBinder<P>(interfaceType, valueType);
    }

    static class Result
    implements Serializable {
        private final Object value;
        private final Exception exception;
        private static final long serialVersionUID = 0L;

        private Result(Object value, Exception exception) {
            this.value = value;
            this.exception = exception;
        }

        public static Result forValue(Object value) {
            return new Result(value, null);
        }

        public static Result forException(Exception e) {
            return new Result(null, e);
        }

        public Object getOrThrow() throws Exception {
            if (this.exception != null) {
                throw this.exception;
            }
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SecondaryBinder<P extends CheckedProvider> {
        private final Class<P> interfaceType;
        private final Type valueType;
        private final List<Class<? extends Throwable>> exceptionTypes;
        private final boolean valid;
        private Class<? extends Annotation> annotationType;
        private Annotation annotation;
        private Key<P> interfaceKey;

        public SecondaryBinder(Class<P> interfaceType, Type valueType) {
            this.interfaceType = (Class).Preconditions.checkNotNull(interfaceType, (Object)"interfaceType");
            this.valueType = (Type).Preconditions.checkNotNull((Object)valueType, (Object)"valueType");
            if (this.checkInterface()) {
                this.exceptionTypes = this.getExceptionType(interfaceType);
                this.valid = true;
            } else {
                this.valid = false;
                this.exceptionTypes = .ImmutableList.of();
            }
        }

        List<Class<? extends Throwable>> getExceptionTypes() {
            return this.exceptionTypes;
        }

        Key<P> getKey() {
            return this.interfaceKey;
        }

        public SecondaryBinder<P> annotatedWith(Class<? extends Annotation> annotationType) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException();
            }
            this.annotationType = annotationType;
            return this;
        }

        public SecondaryBinder<P> annotatedWith(Annotation annotation) {
            if (this.annotationType != null || this.annotation != null) {
                throw new IllegalStateException();
            }
            this.annotation = annotation;
            return this;
        }

        public ScopedBindingBuilder to(P target) {
            Key targetKey = Key.get(this.interfaceType, (Annotation)UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.to(targetKey);
        }

        public ScopedBindingBuilder to(Class<? extends P> targetType) {
            return this.to(Key.get(targetType));
        }

        ScopedBindingBuilder toProviderMethod(CheckedProviderMethod<?> target) {
            Key targetKey = Key.get(CheckedProviderMethod.class, (Annotation)UniqueAnnotations.create());
            ThrowingProviderBinder.this.binder.bind(targetKey).toInstance(target);
            return this.toInternal((Key<CheckedProvider>)targetKey);
        }

        public ScopedBindingBuilder to(Key<? extends P> targetKey) {
            .Preconditions.checkNotNull(targetKey, (Object)"targetKey");
            return this.toInternal(targetKey);
        }

        private ScopedBindingBuilder toInternal(final Key<? extends CheckedProvider> targetKey) {
            final Key resultKey = Key.get(Result.class, (Annotation)UniqueAnnotations.create());
            final Provider resultProvider = ThrowingProviderBinder.this.binder.getProvider(resultKey);
            final Provider targetProvider = ThrowingProviderBinder.this.binder.getProvider(targetKey);
            this.interfaceKey = this.createKey();
            if (this.valid) {
                ThrowingProviderBinder.this.binder.bind(this.interfaceKey).toProvider((Provider)new ProviderWithDependencies<P>(){
                    private final P instance;
                    {
                        this.instance = (CheckedProvider)SecondaryBinder.this.interfaceType.cast(Proxy.newProxyInstance(SecondaryBinder.this.interfaceType.getClassLoader(), new Class[]{SecondaryBinder.this.interfaceType}, new InvocationHandler(){

                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                return ((Result)resultProvider.get()).getOrThrow();
                            }
                        }));
                    }

                    public P get() {
                        return this.instance;
                    }

                    public Set<Dependency<?>> getDependencies() {
                        return .ImmutableSet.of((Object)Dependency.get((Key)resultKey));
                    }
                });
            }
            return ThrowingProviderBinder.this.binder.bind(resultKey).toProvider((Provider)new ProviderWithDependencies<Result>(){

                public Result get() {
                    try {
                        return Result.forValue(((CheckedProvider)targetProvider.get()).get());
                    }
                    catch (Exception e) {
                        for (Class exceptionType : SecondaryBinder.this.exceptionTypes) {
                            if (!exceptionType.isInstance(e)) continue;
                            return Result.forException(e);
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }

                public Set<Dependency<?>> getDependencies() {
                    return .ImmutableSet.of((Object)Dependency.get((Key)targetKey));
                }
            });
        }

        private List<Class<? extends Throwable>> getExceptionType(Class<P> interfaceType) {
            try {
                Method getMethod = interfaceType.getMethod("get", new Class[0]);
                List exceptionLiterals = TypeLiteral.get(interfaceType).getExceptionTypes((Member)getMethod);
                ArrayList results = .Lists.newArrayList();
                for (TypeLiteral exLiteral : exceptionLiterals) {
                    results.add(exLiteral.getRawType().asSubclass(Throwable.class));
                }
                return results;
            }
            catch (SecurityException e) {
                throw new IllegalStateException("Not allowed to inspect exception types", e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("No 'get'method available", e);
            }
        }

        private boolean checkInterface() {
            Type exceptionType;
            boolean tpMode;
            if (!this.checkArgument(this.interfaceType.isInterface(), "%s must be an interface", this.interfaceType.getName())) {
                return false;
            }
            if (!this.checkArgument(this.interfaceType.getGenericInterfaces().length == 1, "%s must extend CheckedProvider (and only CheckedProvider)", this.interfaceType)) {
                return false;
            }
            boolean bl = tpMode = this.interfaceType.getInterfaces()[0] == ThrowingProvider.class;
            if (!tpMode && !this.checkArgument(this.interfaceType.getInterfaces()[0] == CheckedProvider.class, "%s must extend CheckedProvider (and only CheckedProvider)", this.interfaceType)) {
                return false;
            }
            ParameterizedType genericThrowingProvider = (ParameterizedType)this.interfaceType.getGenericInterfaces()[0];
            if (this.interfaceType.getTypeParameters().length == 1) {
                String returnTypeName = this.interfaceType.getTypeParameters()[0].getName();
                Type returnType = genericThrowingProvider.getActualTypeArguments()[0];
                if (!this.checkArgument(returnType instanceof TypeVariable, "%s does not properly extend CheckedProvider, the first type parameter of CheckedProvider (%s) is not a generic type", this.interfaceType, returnType)) {
                    return false;
                }
                if (!this.checkArgument(returnTypeName.equals(((TypeVariable)returnType).getName()), "The generic type (%s) of %s does not match the generic type of CheckedProvider (%s)", returnTypeName, this.interfaceType, ((TypeVariable)returnType).getName())) {
                    return false;
                }
            } else {
                if (!this.checkArgument(this.interfaceType.getTypeParameters().length == 0, "%s has more than one generic type parameter: %s", this.interfaceType, Arrays.asList(this.interfaceType.getTypeParameters()))) {
                    return false;
                }
                if (!this.checkArgument(genericThrowingProvider.getActualTypeArguments()[0].equals(this.valueType), "%s expects the value type to be %s, but it was %s", this.interfaceType, genericThrowingProvider.getActualTypeArguments()[0], this.valueType)) {
                    return false;
                }
            }
            if (tpMode && !this.checkArgument((exceptionType = genericThrowingProvider.getActualTypeArguments()[1]) instanceof Class, "%s has the wrong Exception generic type (%s) when extending CheckedProvider", this.interfaceType, exceptionType)) {
                return false;
            }
            if (this.interfaceType.getDeclaredMethods().length == 1) {
                Method method = this.interfaceType.getDeclaredMethods()[0];
                if (!this.checkArgument(method.getName().equals("get"), "%s may not declare any new methods, but declared %s", this.interfaceType, method)) {
                    return false;
                }
                if (!this.checkArgument(method.getParameterTypes().length == 0, "%s may not declare any new methods, but declared %s", this.interfaceType, method.toGenericString())) {
                    return false;
                }
            } else if (!this.checkArgument(this.interfaceType.getDeclaredMethods().length == 0, "%s may not declare any new methods, but declared %s", this.interfaceType, Arrays.asList(this.interfaceType.getDeclaredMethods()))) {
                return false;
            }
            return true;
        }

        private boolean checkArgument(boolean condition, String messageFormat, Object ... args) {
            if (!condition) {
                ThrowingProviderBinder.this.binder.addError(messageFormat, args);
                return false;
            }
            return true;
        }

        private Key<P> createKey() {
            TypeLiteral typeLiteral;
            if (this.interfaceType.getTypeParameters().length == 1) {
                ParameterizedType type = Types.newParameterizedTypeWithOwner(this.interfaceType.getEnclosingClass(), this.interfaceType, (Type[])new Type[]{this.valueType});
                typeLiteral = TypeLiteral.get((Type)type);
            } else {
                typeLiteral = TypeLiteral.get(this.interfaceType);
            }
            if (this.annotation != null) {
                return Key.get((TypeLiteral)typeLiteral, (Annotation)this.annotation);
            }
            if (this.annotationType != null) {
                return Key.get((TypeLiteral)typeLiteral, this.annotationType);
            }
            return Key.get((TypeLiteral)typeLiteral);
        }
    }
}

