/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.throwingproviders;

import com.google.inject.Binder;
import com.google.inject.Exposed;
import com.google.inject.Key;
import com.google.inject.PrivateBinder;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.util.;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.throwingproviders.CheckedProvider;
import com.google.inject.throwingproviders.ThrowingProviderBinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckedProviderMethod<T>
implements CheckedProvider<T>,
HasDependencies {
    private final Key<T> key;
    private final Class<? extends Annotation> scopeAnnotation;
    private final Object instance;
    private final Method method;
    private final .ImmutableSet<Dependency<?>> dependencies;
    private final List<Provider<?>> parameterProviders;
    private final boolean exposed;
    private final Class<? extends CheckedProvider> checkedProvider;
    private final List<TypeLiteral<?>> exceptionTypes;

    CheckedProviderMethod(Key<T> key, Method method, Object instance, .ImmutableSet<Dependency<?>> dependencies, List<Provider<?>> parameterProviders, Class<? extends Annotation> scopeAnnotation, Class<? extends CheckedProvider> checkedProvider, List<TypeLiteral<?>> exceptionTypes) {
        this.key = key;
        this.scopeAnnotation = scopeAnnotation;
        this.instance = instance;
        this.dependencies = dependencies;
        this.method = method;
        this.parameterProviders = parameterProviders;
        this.exposed = method.isAnnotationPresent(Exposed.class);
        this.checkedProvider = checkedProvider;
        this.exceptionTypes = exceptionTypes;
        method.setAccessible(true);
    }

    void configure(Binder binder) {
        binder = binder.withSource((Object)this.method);
        ThrowingProviderBinder.SecondaryBinder<? extends CheckedProvider> sbinder = ThrowingProviderBinder.create(binder).bind(this.checkedProvider, this.key.getTypeLiteral().getType());
        if (this.key.getAnnotation() != null) {
            sbinder = sbinder.annotatedWith(this.key.getAnnotation());
        } else if (this.key.getAnnotationType() != null) {
            sbinder = sbinder.annotatedWith(this.key.getAnnotationType());
        }
        ScopedBindingBuilder sbbuilder = sbinder.toProviderMethod(this);
        if (this.scopeAnnotation != null) {
            sbbuilder.in(this.scopeAnnotation);
        }
        if (this.exposed) {
            ((PrivateBinder)binder).expose(sbinder.getKey());
        }
        for (TypeLiteral<?> exType : this.exceptionTypes) {
            Class exActual = exType.getRawType();
            if (RuntimeException.class.isAssignableFrom(exActual) || Error.class.isAssignableFrom(exActual)) continue;
            boolean notAssignable = true;
            for (Class<Throwable> exExpected : sbinder.getExceptionTypes()) {
                if (!exExpected.isAssignableFrom(exActual)) continue;
                notAssignable = false;
                break;
            }
            if (!notAssignable) continue;
            binder.addError("%s is not compatible with the exceptions (%s) declared in the CheckedProvider interface (%s)", new Object[]{exActual, sbinder.getExceptionTypes(), this.checkedProvider});
        }
    }

    @Override
    public T get() throws Exception {
        Object[] parameters = new Object[this.parameterProviders.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = this.parameterProviders.get(i).get();
        }
        try {
            Object result = this.method.invoke(this.instance, parameters);
            return (T)result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new IllegalStateException(t);
        }
    }

    public Set<Dependency<?>> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return "@CheckedProvides " + .StackTraceElements.forMember((Member)this.method).toString();
    }
}

