/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.tools;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Map;
import org.onion_lang.onion.compiler.CompiledClass;
import org.onion_lang.onion.compiler.CompilerConfig;
import org.onion_lang.onion.compiler.OnionClassLoader;
import org.onion_lang.onion.compiler.OnionCompiler;
import org.onion_lang.onion.compiler.ScriptFailureException;
import org.onion_lang.onion.compiler.utility.Messages;
import org.onion_lang.onion.compiler.utility.Systems;
import org.onion_lang.onion.tools.CommandLineParser;
import org.onion_lang.onion.tools.OptionConfiguration;
import org.onion_lang.onion.tools.ParseFailure;
import org.onion_lang.onion.tools.ParseResult;
import org.onion_lang.onion.tools.ParseSuccess;

public class ScriptRunner {
    private static final String CLASSPATH = "-classpath";
    private static final String ENCODING = "-encoding";
    private static final String MAX_ERROR = "-maxErrorReport";
    private static final String[] DEFAULT_CLASSPATH = new String[]{"."};
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private static final String DEFAULT_OUTPUT = ".";
    private static final int DEFAULT_MAX_ERROR = 10;
    private CommandLineParser commandLineParser = new CommandLineParser(new OptionConfiguration[]{ScriptRunner.conf("-classpath", true), ScriptRunner.conf("-encoding", true), ScriptRunner.conf("-maxErrorReport", true)});
    static /* synthetic */ Class array$Ljava$lang$String;

    private static OptionConfiguration conf(String optionName, boolean requireArgument) {
        return new OptionConfiguration(optionName, requireArgument);
    }

    public int run(String[] commandLine) {
        if (commandLine.length == 0) {
            this.printUsage();
            return -1;
        }
        ParseSuccess result = this.parseCommandLine(commandLine);
        if (result == null) {
            return -1;
        }
        CompilerConfig config = this.createConfig(result);
        if (config == null) {
            return -1;
        }
        String[] params = result.getArguments().toArray(new String[0]);
        if (params.length == 0) {
            this.printUsage();
            return -1;
        }
        CompiledClass[] classes = this.compile(config, new String[]{params[0]});
        if (classes == null) {
            return -1;
        }
        String[] scriptParams = new String[params.length - 1];
        for (int i = 1; i < params.length; ++i) {
            scriptParams[i - 1] = params[i];
        }
        return this.startScript(classes, config.getClassPath(), scriptParams) ? 0 : 1;
    }

    private boolean startScript(CompiledClass[] classes, String[] classpath, String[] params) {
        try {
            OnionClassLoader loader = new OnionClassLoader(classpath, OnionClassLoader.class.getClassLoader(), classes);
            Thread.currentThread().setContextClassLoader(loader);
            Method main = this.findFirstMainMethod(loader, classes);
            if (main == null) {
                return false;
            }
            main.invoke(null, new Object[]{params});
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            throw new ScriptFailureException(e.getCause());
        }
    }

    private Method findFirstMainMethod(OnionClassLoader loader, CompiledClass[] classes) throws ClassNotFoundException {
        for (int i = 0; i < classes.length; ++i) {
            String className = classes[i].getClassName();
            Class<?> clazz = Class.forName(className, true, loader);
            try {
                Method main = clazz.getMethod("main", array$Ljava$lang$String == null ? ScriptRunner.class$("[Ljava.lang.String;") : array$Ljava$lang$String);
                int modifier = main.getModifiers();
                if ((modifier & 1) == 0 || (modifier & 8) == 0) continue;
                return main;
            }
            catch (NoSuchMethodException e1) {
                // empty catch block
            }
        }
        return null;
    }

    protected void printUsage() {
        ScriptRunner.printerr("Usage: onion [-options] <source file> <command line arguments>");
        ScriptRunner.printerr("options: ");
        ScriptRunner.printerr("  -classpath <class path>     specify classpath");
        ScriptRunner.printerr("  -encoding <encoding>        specify source file encoding");
        ScriptRunner.printerr("  -maxErrorReport <number>    set number of errors reported");
    }

    private ParseSuccess parseCommandLine(String[] commandLine) {
        ParseResult result = this.commandLineParser.parse(commandLine);
        if (result.getStatus() == 1) {
            int i;
            ParseFailure failure = (ParseFailure)result;
            String[] lackedOptions = failure.getLackedOptions();
            String[] invalidOptions = failure.getInvalidOptions();
            for (i = 0; i < invalidOptions.length; ++i) {
                ScriptRunner.printerr(Messages.get("error.command.invalidArgument", invalidOptions[i]));
            }
            for (i = 0; i < lackedOptions.length; ++i) {
                ScriptRunner.printerr(Messages.get("error.command..noArgument", lackedOptions[i]));
            }
            return null;
        }
        return (ParseSuccess)result;
    }

    private CompilerConfig createConfig(ParseSuccess result) {
        Map option = result.getOptions();
        Map noargOption = result.getNoArgumentOptions();
        String[] classpath = this.checkClasspath((String)option.get(CLASSPATH));
        String encoding = this.checkEncoding((String)option.get(ENCODING));
        Integer maxErrorReport = this.checkMaxErrorReport((String)option.get(MAX_ERROR));
        if (encoding == null || maxErrorReport == null) {
            return null;
        }
        return new CompilerConfig(classpath, encoding, DEFAULT_OUTPUT, maxErrorReport);
    }

    private CompiledClass[] compile(CompilerConfig config, String[] fileNames) {
        return new OnionCompiler(config).compile(fileNames);
    }

    private String[] checkClasspath(String classpath) {
        if (classpath == null) {
            return DEFAULT_CLASSPATH;
        }
        String[] paths = ScriptRunner.pathArray(classpath);
        return paths;
    }

    private String checkEncoding(String encoding) {
        if (encoding == null) {
            return System.getProperty("file.encoding");
        }
        try {
            "".getBytes(encoding);
            return encoding;
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(Messages.get("error.command.invalidEncoding", ENCODING));
            return null;
        }
    }

    private Integer checkMaxErrorReport(String maxErrorReport) {
        if (maxErrorReport == null) {
            return new Integer(10);
        }
        try {
            int value = Integer.parseInt(maxErrorReport);
            if (value > 0) {
                return new Integer(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ScriptRunner.printerr(Messages.get("error.command.requireNaturalNumber", MAX_ERROR));
        return null;
    }

    private static String[] pathArray(String path) {
        return path.split(Systems.getPathSeparator());
    }

    private static void printerr(String message) {
        System.err.println(message);
    }

    public static void main(String[] args) throws Throwable {
        try {
            new ScriptRunner().run(args);
        }
        catch (ScriptFailureException e) {
            throw e.getCause();
        }
    }
}

