/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.tools;

import java.util.ArrayList;
import java.util.HashMap;
import org.onion_lang.onion.tools.OptionConfiguration;
import org.onion_lang.onion.tools.ParseFailure;
import org.onion_lang.onion.tools.ParseResult;
import org.onion_lang.onion.tools.ParseSuccess;

public class CommandLineParser {
    private final OptionConfiguration[] configurations;

    public CommandLineParser(OptionConfiguration[] configurations) {
        this.configurations = configurations;
    }

    private static boolean isOptionName(String name) {
        return name.startsWith("-");
    }

    public ParseResult parse(String[] commandLine) {
        HashMap<String, Object> noArgumentOptions = new HashMap<String, Object>();
        HashMap<String, String> options = new HashMap<String, String>();
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> lackedOptions = new ArrayList<String>();
        ArrayList<String> invalidOptions = new ArrayList<String>();
        int i = 0;
        while (i < commandLine.length && CommandLineParser.isOptionName(commandLine[i])) {
            String param = commandLine[i];
            OptionConfiguration configuration = this.getConfiguration(param);
            if (configuration == null) {
                invalidOptions.add(param);
                ++i;
                continue;
            }
            if (configuration.requireArgument()) {
                if (i + 1 >= commandLine.length) {
                    lackedOptions.add(param);
                } else {
                    options.put(param, commandLine[i + 1]);
                }
                i += 2;
                continue;
            }
            noArgumentOptions.put(param, new Object());
            ++i;
        }
        while (i < commandLine.length) {
            arguments.add(commandLine[i]);
            ++i;
        }
        if (lackedOptions.size() == 0 && invalidOptions.size() == 0) {
            return new ParseSuccess(noArgumentOptions, options, arguments);
        }
        return new ParseFailure(lackedOptions.toArray(new String[0]), invalidOptions.toArray(new String[0]));
    }

    private OptionConfiguration getConfiguration(String optionName) {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].getOptionName().equals(optionName)) continue;
            return this.configurations[i];
        }
        return null;
    }
}

