/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.lang.kernel.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbolComparator;
import org.onion_lang.onion.lang.kernel.type.ParameterMatcher;
import org.onion_lang.onion.lang.kernel.type.StandardParameterMatcher;
import org.onion_lang.onion.lang.kernel.type.TypeRules;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class ConstructorFinder {
    private static Comparator sorter = new Comparator(){

        public int compare(Object constructor1, Object constructor2) {
            ConstructorSymbol c1 = (ConstructorSymbol)constructor1;
            ConstructorSymbol c2 = (ConstructorSymbol)constructor2;
            TypeSymbol[] arg1 = c1.getArguments();
            TypeSymbol[] arg2 = c2.getArguments();
            int length = arg1.length;
            if (ConstructorFinder.isAllSuperType(arg2, arg1)) {
                return -1;
            }
            if (ConstructorFinder.isAllSuperType(arg1, arg2)) {
                return 1;
            }
            return 0;
        }
    };
    private ParameterMatcher matcher = new StandardParameterMatcher();

    public ConstructorSymbol[] find(ClassSymbol target, ExpressionNode[] args) {
        ConstructorSymbol constructor2;
        TreeSet constructors = new TreeSet(new ConstructorSymbolComparator());
        this.find(constructors, target, args);
        ArrayList selected = new ArrayList();
        selected.addAll(constructors);
        Collections.sort(selected, sorter);
        if (selected.size() < 2) {
            return selected.toArray(new ConstructorSymbol[0]);
        }
        ConstructorSymbol constructor1 = (ConstructorSymbol)selected.get(0);
        if (this.isAmbiguous(constructor1, constructor2 = (ConstructorSymbol)selected.get(1))) {
            return selected.toArray(new ConstructorSymbol[0]);
        }
        return new ConstructorSymbol[]{constructor1};
    }

    private boolean isAmbiguous(ConstructorSymbol constructor1, ConstructorSymbol constructor2) {
        return sorter.compare(constructor1, constructor2) >= 0;
    }

    private void find(Set constructors, ClassSymbol target, ExpressionNode[] arguments) {
        if (target == null) {
            return;
        }
        ConstructorSymbol[] cs = target.getConstructors();
        for (int i = 0; i < cs.length; ++i) {
            ConstructorSymbol c = cs[i];
            if (!this.matcher.matches(c.getArguments(), arguments)) continue;
            constructors.add(c);
        }
    }

    private static boolean isAllSuperType(TypeSymbol[] arg1, TypeSymbol[] arg2) {
        for (int i = 0; i < arg1.length; ++i) {
            if (TypeRules.isSuperType(arg1[i], arg2[i])) continue;
            return false;
        }
        return true;
    }
}

