/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class TryStatement extends Statement {
  
  public final BlockStatement tryBlock;

  public final BlockStatement[] recBlocks;
  
  public final ArgumentDeclaration[] arguments;
  
  public final BlockStatement finBlock;

  public TryStatement(BlockStatement tryBlock, BlockStatement[] recBlocks, ArgumentDeclaration[] arguments, BlockStatement finBlock) {
    this.tryBlock = tryBlock;
    this.recBlocks = recBlocks;
    this.arguments = arguments;
    this.finBlock = finBlock;
    setChild(tryBlock);
    setChildren(recBlocks);
    setChildren(arguments);
    setChild(finBlock);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
}