/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * @author Kota Mizushima
 * Date: 2005/04/11
 */
public class CaseBranch extends SimpleASTNode {
  
  private Expression[] expressions;
  
  private BlockStatement block;

  public CaseBranch(Expression[] expressions, BlockStatement block) {
    this.expressions = expressions;
    this.block = block;
    setChildren(expressions);
    setChild(block);
  }
  
  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public Expression[] getExpressions(){
    return expressions;
  }
  
  public BlockStatement getBlock(){
    return block;
  }
  
}
