/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class ArgumentDeclaration extends SimpleASTNode {
  
  private int id;
  
  private final String name;
  
  private TypeSpecifier type;

  public ArgumentDeclaration(String name, TypeSpecifier type) {
    this.name = name;
    this.type = type;
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public int getId() {
    return id;
  }

  public void setId(int id) {
    this.id = id;
  }

  public String getName() {
    return name;
  }

  public TypeSpecifier getType() {
    return type;
  }
    
}