/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel.type;


/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class NullSymbol implements TypeSymbol {
  public static NullSymbol NULL = new NullSymbol("null");
  
  private String name;
  
  private NullSymbol(String name) {
    this.name = name;
  }
  
  public String getName(){
    return name;
  }
  
  public boolean isArrayType() {
    return false;
  }
  
  public boolean isBasicType() {
    return false;
  }
  
  public boolean isClassType() {
    return false;
  }
  
  public boolean isNullType() {
    return true;
  }
  
  public boolean isObjectType(){
    return false;
  }
}