/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class SuperInitNode implements KernelNode {  
  private ClassSymbol classType;
  private TypeSymbol[] arguments;
  private ExpressionNode[] expressions;

  public SuperInitNode(
    ClassSymbol classType, TypeSymbol[] arguments, ExpressionNode[] expressions){
    this.classType = classType;
    this.arguments = arguments;
    this.expressions = expressions;
  }
  
  public ClassSymbol getClassType() {
    return classType;
  }
  
  public TypeSymbol[] getArguments() {
    return arguments;
  }
  
  public ExpressionNode[] getExpressions() {
    return expressions;
  }
  
}
