/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class FieldAssignmentNode extends ExpressionNode {
  private final ExpressionNode object;
  private final FieldSymbol field;
  private final ExpressionNode value;

  public FieldAssignmentNode(
    ExpressionNode target, FieldSymbol field, ExpressionNode value
  ) {
    this.object = target;
    this.field = field;
    this.value = value;
  }
  
  public TypeSymbol type() { return field.getType(); }

  public ExpressionNode getObject() { return object; }

  public FieldSymbol getField() { return field; }

  public ExpressionNode getValue() { return value; }
}
